/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.NikonCodecOptions;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NikonReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NikonReader.class);
    public static final String[] NEF_SUFFIX = new String[]{"nef"};
    private static final int TIFF_EPS_STANDARD = 37398;
    private static final int COLOR_MAP = 33422;
    private static final int FIRMWARE_VERSION = 1;
    private static final int ISO = 2;
    private static final int QUALITY = 4;
    private static final int MAKER_WHITE_BALANCE = 5;
    private static final int SHARPENING = 6;
    private static final int FOCUS_MODE = 7;
    private static final int FLASH_SETTING = 8;
    private static final int FLASH_MODE = 9;
    private static final int WHITE_BALANCE_FINE = 11;
    private static final int WHITE_BALANCE_RGB_COEFFS = 12;
    private static final int FLASH_COMPENSATION = 18;
    private static final int TONE_COMPENSATION = 129;
    private static final int LENS_TYPE = 131;
    private static final int LENS = 132;
    private static final int FLASH_USED = 135;
    private static final int CURVE = 140;
    private static final int COLOR_MODE = 141;
    private static final int LIGHT_TYPE = 144;
    private static final int HUE = 146;
    private static final int CAPTURE_EDITOR_DATA = 3585;
    protected int makerNoteOffset;
    protected IFD original;
    private TiffRational[] whiteBalance;
    private Object cfaPattern;
    private int[] curve;
    private int[] vPredictor;
    private boolean lossyCompression;
    private int split = -1;
    private byte[] lastPlane = null;
    private int lastIndex = -1;

    public NikonReader() {
        super("Nikon NEF", new String[]{"nef", "tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
        this.mergeSubIFDs = true;
        this.canSeparateSeries = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (NikonReader.checkSuffix((String)name, (String[])NEF_SUFFIX)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        if (ifd.containsKey((Object)37398)) {
            return true;
        }
        String make = ifd.getIFDTextValue(271);
        return make != null && make.indexOf("Nikon") != -1;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        IFD ifd = (IFD)this.ifds.get(no);
        int[] bps = ifd.getBitsPerSample();
        int dataSize = bps[0];
        long[] byteCounts = ifd.getStripByteCounts();
        long totalBytes = 0L;
        for (long b : byteCounts) {
            totalBytes += b;
        }
        if (totalBytes == (long)FormatTools.getPlaneSize((IFormatReader)this) || bps.length > 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        if (this.lastPlane == null || this.lastIndex != no) {
            boolean compressed;
            long[] offsets = ifd.getStripOffsets();
            boolean maybeCompressed = ifd.getCompression() == TiffCompression.NIKON;
            boolean bl = compressed = this.vPredictor != null && this.curve != null && maybeCompressed;
            if (!maybeCompressed && dataSize == 14) {
                dataSize = 16;
            }
            ByteArrayOutputStream src = new ByteArrayOutputStream();
            NikonCodec codec = new NikonCodec();
            NikonCodecOptions options = new NikonCodecOptions();
            options.width = this.getSizeX();
            options.height = this.getSizeY();
            options.bitsPerSample = dataSize;
            options.curve = this.curve;
            if (this.vPredictor != null) {
                options.vPredictor = new int[this.vPredictor.length];
            }
            options.lossless = !this.lossyCompression;
            options.split = this.split;
            for (int i = 0; i < byteCounts.length; ++i) {
                byte[] t = new byte[(int)byteCounts[i]];
                this.in.seek(offsets[i]);
                this.in.read(t);
                if (compressed) {
                    options.maxBytes = (int)byteCounts[i];
                    System.arraycopy(this.vPredictor, 0, options.vPredictor, 0, this.vPredictor.length);
                    t = codec.decompress(t, (CodecOptions)options);
                }
                src.write(t);
            }
            RandomAccessInputStream bb = new RandomAccessInputStream((IRandomAccess)new ByteArrayHandle(src.toByteArray()));
            short[] pix = new short[this.getSizeX() * this.getSizeY() * 3];
            src.close();
            int[] colorMap = new int[]{1, 0, 2, 1};
            short[] ifdColors = (short[])ifd.get((Object)33422);
            if (ifdColors != null && ifdColors.length >= colorMap.length) {
                int q;
                boolean colorsValid = true;
                for (q = 0; q < colorMap.length; ++q) {
                    if (ifdColors[q] >= 0 && ifdColors[q] <= 2) continue;
                    colorsValid = false;
                    break;
                }
                if (colorsValid) {
                    for (q = 0; q < colorMap.length; ++q) {
                        colorMap[q] = ifdColors[q];
                    }
                }
            }
            boolean interleaveRows = offsets.length == 1 && !maybeCompressed && colorMap[0] != 0;
            for (int row = 0; row < this.getSizeY(); ++row) {
                int realRow = interleaveRows ? (row < this.getSizeY() / 2 ? row * 2 : (row - this.getSizeY() / 2) * 2 + 1) : row;
                for (int col = 0; col < this.getSizeX(); ++col) {
                    short val = (short)(bb.readBits(dataSize) & 0xFFFF);
                    int mapIndex = realRow % 2 * 2 + col % 2;
                    int redOffset = realRow * this.getSizeX() + col;
                    int greenOffset = (this.getSizeY() + realRow) * this.getSizeX() + col;
                    int blueOffset = (2 * this.getSizeY() + realRow) * this.getSizeX() + col;
                    if (colorMap[mapIndex] == 0) {
                        pix[redOffset] = this.adjustForWhiteBalance(val, 0);
                    } else if (colorMap[mapIndex] == 1) {
                        pix[greenOffset] = this.adjustForWhiteBalance(val, 1);
                    } else if (colorMap[mapIndex] == 2) {
                        pix[blueOffset] = this.adjustForWhiteBalance(val, 2);
                    }
                    if (!maybeCompressed || compressed) continue;
                    int toSkip = 0;
                    if (col % 10 == 9) {
                        toSkip = 1;
                    }
                    if (col == this.getSizeX() - 1) {
                        toSkip = 10;
                    }
                    bb.skipBits((long)(toSkip * 8));
                }
            }
            bb.close();
            this.lastPlane = new byte[FormatTools.getPlaneSize((IFormatReader)this)];
            ImageTools.interpolate((short[])pix, (byte[])this.lastPlane, (int[])colorMap, (int)this.getSizeX(), (int)this.getSizeY(), (boolean)this.isLittleEndian());
            this.lastIndex = no;
        }
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType()) * 3;
        int rowLen = w * bpp;
        int width = this.getSizeX() * bpp;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(this.lastPlane, (row + y) * width + x * bpp, buf, row * rowLen, rowLen);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.makerNoteOffset = 0;
            this.original = null;
            this.split = -1;
            this.whiteBalance = null;
            this.cfaPattern = null;
            this.curve = null;
            this.vPredictor = null;
            this.lossyCompression = false;
            this.lastPlane = null;
            this.lastIndex = -1;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.imageCount = this.ifds.size();
        IFD firstIFD = (IFD)this.ifds.get(0);
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        int samples = firstIFD.getSamplesPerPixel();
        boolean bl = m.rgb = samples > 1 || photo == PhotoInterp.RGB || photo == PhotoInterp.CFA_ARRAY;
        if (photo == PhotoInterp.CFA_ARRAY) {
            samples = 3;
        }
        m.sizeX = (int)firstIFD.getImageWidth();
        m.sizeY = (int)firstIFD.getImageLength();
        m.sizeZ = 1;
        m.sizeC = this.isRGB() ? samples : 1;
        m.sizeT = this.ifds.size();
        m.pixelType = firstIFD.getPixelType();
        m.indexed = false;
        IFDList exifIFDs = this.tiffParser.getExifIFDs();
        if (exifIFDs.size() > 0) {
            IFD exifIFD = (IFD)exifIFDs.get(0);
            this.tiffParser.fillInIFD(exifIFD);
            for (Integer key : exifIFD.keySet()) {
                int tag = key;
                String name = IFD.getIFDTagName((int)tag);
                if (tag == 41730) {
                    byte[] cfa = (byte[])exifIFD.get((Object)key);
                    int[] colorMap = new int[cfa.length];
                    for (int i = 0; i < cfa.length; ++i) {
                        colorMap[i] = cfa[i];
                    }
                    this.addGlobalMeta(name, colorMap);
                    this.cfaPattern = colorMap;
                    continue;
                }
                this.addGlobalMeta(name, exifIFD.get((Object)key));
                if (!name.equals("MAKER_NOTE")) continue;
                byte[] b = (byte[])exifIFD.get((Object)key);
                int extra = new String(b, 0, 10, "UTF-8").startsWith("Nikon") ? 10 : 0;
                byte[] buf = new byte[b.length];
                System.arraycopy(b, extra, buf, 0, buf.length - extra);
                IFD note = null;
                try (RandomAccessInputStream makerNote = new RandomAccessInputStream(buf);){
                    TiffParser tp = new TiffParser(makerNote);
                    note = tp.getFirstIFD();
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to parse first IFD", (Throwable)e);
                }
                if (note == null) continue;
                for (Integer nextKey : note.keySet()) {
                    int nextTag = nextKey;
                    this.addGlobalMeta(name, note.get((Object)nextKey));
                    if (nextTag == 150) {
                        b = (byte[])note.get((Object)nextKey);
                        RandomAccessInputStream s = new RandomAccessInputStream(b);
                        byte check1 = s.readByte();
                        byte check2 = s.readByte();
                        this.lossyCompression = check1 != 70;
                        this.vPredictor = new int[4];
                        for (int q = 0; q < this.vPredictor.length; ++q) {
                            this.vPredictor[q] = s.readShort();
                        }
                        this.curve = new int[16385];
                        int bps = ((IFD)this.ifds.get(0)).getBitsPerSample()[0];
                        int max = 1 << bps & Short.MAX_VALUE;
                        int step = 0;
                        int csize = s.readShort();
                        if (csize > 1) {
                            step = max / (csize - 1);
                        }
                        if (check1 == 68 && check2 == 32 && step > 0) {
                            int i;
                            for (i = 0; i < csize; ++i) {
                                this.curve[i * step] = s.readShort();
                            }
                            for (i = 0; i < max; ++i) {
                                int n = i % step;
                                this.curve[i] = (this.curve[i - n] * (step - n) + this.curve[i - n + step] * n) / step;
                            }
                            s.seek(562L);
                            this.split = s.readShort();
                        } else {
                            int maxValue = (int)Math.pow(2.0, bps) - 1;
                            Arrays.fill(this.curve, maxValue);
                            int nElements = (int)(s.length() - s.getFilePointer()) / 2;
                            if (nElements < 100) {
                                for (int i = 0; i < this.curve.length; ++i) {
                                    this.curve[i] = (short)i;
                                }
                            } else {
                                for (int q = 0; q < nElements; ++q) {
                                    this.curve[q] = s.readShort();
                                }
                            }
                        }
                        s.close();
                        continue;
                    }
                    if (nextTag != 12) continue;
                    this.whiteBalance = (TiffRational[])note.get((Object)nextKey);
                }
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.original = (IFD)this.ifds.get(0);
        if (this.cfaPattern != null) {
            this.original.putIFDValue(320, (Object)((int[])this.cfaPattern));
        }
        this.ifds.set(0, (Object)this.original);
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.imageCount = 1;
        m.sizeT = 1;
        if (((IFD)this.ifds.get(0)).getSamplesPerPixel() == 1) {
            m.interleaved = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private short adjustForWhiteBalance(short val, int index) {
        if (this.whiteBalance != null && this.whiteBalance.length == 3) {
            return (short)((double)val * this.whiteBalance[index].doubleValue());
        }
        return val;
    }
}

