/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.bmp;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import java.text.DecimalFormat;

public class BmpHeaderDescriptor
extends TagDescriptor<BmpHeaderDirectory> {
    public BmpHeaderDescriptor(@NotNull BmpHeaderDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case -2: {
                return this.getBitmapTypeDescription();
            }
            case 5: {
                return this.getCompressionDescription();
            }
            case 10: {
                return this.getRenderingDescription();
            }
            case 11: {
                return this.getColorEncodingDescription();
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return BmpHeaderDescriptor.formatHex(((BmpHeaderDirectory)this._directory).getLongObject(tagType), 8);
            }
            case 16: {
                return this.getColorSpaceTypeDescription();
            }
            case 17: 
            case 18: 
            case 19: {
                return BmpHeaderDescriptor.formatFixed1616(((BmpHeaderDirectory)this._directory).getLongObject(tagType));
            }
            case 20: {
                return this.getRenderingIntentDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getBitmapTypeDescription() {
        BmpHeaderDirectory.BitmapType bitmapType = ((BmpHeaderDirectory)this._directory).getBitmapType();
        return bitmapType == null ? null : bitmapType.toString();
    }

    @Nullable
    public String getCompressionDescription() {
        BmpHeaderDirectory.Compression compression = ((BmpHeaderDirectory)this._directory).getCompression();
        if (compression != null) {
            return compression.toString();
        }
        Integer value = ((BmpHeaderDirectory)this._directory).getInteger(5);
        return value == null ? null : "Illegal value 0x" + Integer.toHexString(value);
    }

    @Nullable
    public String getRenderingDescription() {
        BmpHeaderDirectory.RenderingHalftoningAlgorithm renderingHalftoningAlgorithm = ((BmpHeaderDirectory)this._directory).getRendering();
        return renderingHalftoningAlgorithm == null ? null : renderingHalftoningAlgorithm.toString();
    }

    @Nullable
    public String getColorEncodingDescription() {
        BmpHeaderDirectory.ColorEncoding colorEncoding = ((BmpHeaderDirectory)this._directory).getColorEncoding();
        return colorEncoding == null ? null : colorEncoding.toString();
    }

    @Nullable
    public String getColorSpaceTypeDescription() {
        BmpHeaderDirectory.ColorSpaceType colorSpaceType = ((BmpHeaderDirectory)this._directory).getColorSpaceType();
        return colorSpaceType == null ? null : colorSpaceType.toString();
    }

    @Nullable
    public String getRenderingIntentDescription() {
        BmpHeaderDirectory.RenderingIntent renderingIntent = ((BmpHeaderDirectory)this._directory).getRenderingIntent();
        return renderingIntent == null ? null : renderingIntent.toString();
    }

    @Nullable
    public static String formatHex(@Nullable Integer value, int digits) {
        return value == null ? null : BmpHeaderDescriptor.formatHex((long)value.intValue() & 0xFFFFFFFFL, digits);
    }

    @NotNull
    public static String formatHex(int value, int digits) {
        return BmpHeaderDescriptor.formatHex((long)value & 0xFFFFFFFFL, digits);
    }

    @Nullable
    public static String formatHex(@Nullable Long value, int digits) {
        return value == null ? null : BmpHeaderDescriptor.formatHex((long)value, digits);
    }

    @NotNull
    public static String formatHex(long value, int digits) {
        return String.format("0x%0" + digits + "X", value);
    }

    @Nullable
    public static String formatFixed1616(Integer value) {
        return value == null ? null : BmpHeaderDescriptor.formatFixed1616((long)value.intValue() & 0xFFFFFFFFL);
    }

    @NotNull
    public static String formatFixed1616(int value) {
        return BmpHeaderDescriptor.formatFixed1616((long)value & 0xFFFFFFFFL);
    }

    @Nullable
    public static String formatFixed1616(Long value) {
        return value == null ? null : BmpHeaderDescriptor.formatFixed1616((long)value);
    }

    @NotNull
    public static String formatFixed1616(long value) {
        Double d = (double)value / 65536.0;
        DecimalFormat format = new DecimalFormat("0.###");
        return format.format(d);
    }
}

