/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class Ecat7Reader
extends FormatReader {
    public static final String ECAT7_MAGIC = "MATRIX72v";
    public static final String ECAT7_MAGIC_REGEX = "MATRIX7[012]v";
    private static final long HEADER_SIZE = 1536L;

    public Ecat7Reader() {
        super("ECAT7", "v");
        this.domains = new String[]{"Medical Imaging"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = ECAT7_MAGIC.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).equals(ECAT7_MAGIC);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] zct = this.getZCTCoords(no);
        int tSkip = 0;
        for (int i = 0; i < zct[2]; ++i) {
            tSkip += 512;
            if (i <= 0 || i % 30 != 0) continue;
            tSkip += 512;
        }
        this.in.seek(1536L + (long)(no * FormatTools.getPlaneSize(this)) + (long)tSkip);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int j;
        void var108_117;
        int n;
        void var108_113;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        String check = this.in.readString(14).trim();
        if (!check.matches(ECAT7_MAGIC_REGEX)) {
            throw new FormatException("Invalid ECAT 7 file.");
        }
        String originalPath = this.in.readString(32);
        short version = this.in.readShort();
        short systemType = this.in.readShort();
        short fileType = this.in.readShort();
        String serialNumber = this.in.readString(10);
        int scanStart = this.in.readInt();
        String isotopeName = this.in.readString(8);
        float isotopeHalflife = this.in.readFloat();
        String radioPharmaceutical = this.in.readString(32);
        float gantryTilt = this.in.readFloat();
        float gantryRotation = this.in.readFloat();
        float bedElevation = this.in.readFloat();
        float intrinsicTilt = this.in.readFloat();
        short wobbleSpeed = this.in.readShort();
        short sourceType = this.in.readShort();
        float distanceScanned = this.in.readFloat();
        float transaxialFOV = this.in.readFloat();
        short angularCompression = this.in.readShort();
        short coinSampleMode = this.in.readShort();
        short axialSampleMode = this.in.readShort();
        float calibrationFactor = this.in.readFloat();
        short calibrationUnits = this.in.readShort();
        short calibrationLabel = this.in.readShort();
        short compression = this.in.readShort();
        String studyType = this.in.readString(12);
        String patientID = this.in.readString(16);
        String patientName = this.in.readString(32);
        String patientSex = this.in.readString(1);
        String patientDexterity = this.in.readString(1);
        float patientAge = this.in.readFloat();
        float patientHeight = this.in.readFloat();
        float patientWeight = this.in.readFloat();
        int patientBirthDate = this.in.readInt();
        String physicianName = this.in.readString(32);
        String operatorName = this.in.readString(32);
        String description = this.in.readString(32);
        short acquisitionType = this.in.readShort();
        short patientOrientation = this.in.readShort();
        String facilityName = this.in.readString(20);
        ms0.sizeZ = this.in.readShort();
        ms0.sizeT = this.in.readShort();
        short numGates = this.in.readShort();
        short numBedPositions = this.in.readShort();
        float initBedPosition = this.in.readFloat();
        float[] bedPositions = new float[15];
        for (int i = 0; i < bedPositions.length; ++i) {
            bedPositions[i] = this.in.readFloat();
        }
        float planeSeparation = this.in.readFloat();
        short lowerThreshold = this.in.readShort();
        short trueLowerThreshold = this.in.readShort();
        short trueUpperThreshold = this.in.readShort();
        String processCode = this.in.readString(10);
        short acquisitionMode = this.in.readShort();
        float binSize = this.in.readFloat();
        float branchingFraction = this.in.readFloat();
        int doseStartTime = this.in.readInt();
        float dosage = this.in.readFloat();
        float wellCounterCorrectionFactor = this.in.readFloat();
        String dataUnits = this.in.readString(32);
        short septaState = this.in.readShort();
        short[] fillCTI = new short[6];
        for (int i = 0; i < fillCTI.length; ++i) {
            fillCTI[i] = this.in.readShort();
        }
        this.in.skipBytes(512);
        short dataType = this.in.readShort();
        short numDimensions = this.in.readShort();
        ms0.sizeX = this.in.readShort();
        ms0.sizeY = this.in.readShort();
        this.in.skipBytes(2);
        float xOffset = this.in.readFloat();
        float yOffset = this.in.readFloat();
        float zOffset = this.in.readFloat();
        float reconZoom = this.in.readFloat();
        float scaleFactor = this.in.readFloat();
        short imageMin = this.in.readShort();
        short imageMax = this.in.readShort();
        float xPixelSize = this.in.readFloat();
        float yPixelSize = this.in.readFloat();
        float zPixelSize = this.in.readFloat();
        int frameDuration = this.in.readInt();
        int frameStartTime = this.in.readInt();
        short filterCode = this.in.readShort();
        float xResolution = this.in.readFloat();
        float yResolution = this.in.readFloat();
        float zResolution = this.in.readFloat();
        float numRElements = this.in.readFloat();
        float numAngles = this.in.readFloat();
        float zRotationAngle = this.in.readFloat();
        float decayCorrectionFactor = this.in.readFloat();
        int processingCode = this.in.readInt();
        int gateDuration = this.in.readInt();
        int rWaveOffset = this.in.readInt();
        int numAcceptedBeats = this.in.readInt();
        float filterCutoffFrequency = this.in.readFloat();
        float filterResolution = this.in.readFloat();
        float filterRampSlope = this.in.readFloat();
        short filterOrder = this.in.readShort();
        float filterScatterFraction = this.in.readFloat();
        float filterScatterSlope = this.in.readFloat();
        String annotation = this.in.readString(40);
        float[][] matrix = new float[3][4];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j2 = 0; j2 < matrix[i].length - 1; ++j2) {
                matrix[i][j2] = this.in.readFloat();
            }
        }
        float rFilterCutoff = this.in.readFloat();
        float rFilterResolution = this.in.readFloat();
        short rFilterCode = this.in.readShort();
        short rFilterOrder = this.in.readShort();
        float zFilterCutoff = this.in.readFloat();
        float zFilterResolution = this.in.readFloat();
        short zFilterCode = this.in.readShort();
        short zFilterOrder = this.in.readShort();
        matrix[0][3] = this.in.readFloat();
        matrix[1][3] = this.in.readFloat();
        matrix[2][3] = this.in.readFloat();
        short scatterType = this.in.readShort();
        short reconType = this.in.readShort();
        short reconViews = this.in.readShort();
        short[] ctiFill = new short[87];
        for (int i = 0; i < ctiFill.length; ++i) {
            ctiFill[i] = this.in.readShort();
        }
        short[] userFill = new short[48];
        boolean bl = false;
        while (var108_113 < userFill.length) {
            userFill[var108_113] = this.in.readShort();
            ++var108_113;
        }
        ms0.sizeC = 1;
        ms0.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        ms0.dimensionOrder = "XYZTC";
        switch (dataType) {
            case 6: {
                ms0.pixelType = 3;
                break;
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
        this.addGlobalMeta("Original path", originalPath);
        this.addGlobalMeta("Version", version);
        this.addGlobalMeta("System type", systemType);
        this.addGlobalMeta("File type", fileType);
        this.addGlobalMeta("Serial number", serialNumber);
        this.addGlobalMeta("Scan start", scanStart);
        this.addGlobalMeta("Isotope Name", isotopeName);
        this.addGlobalMeta("Isotope half-life", isotopeHalflife);
        this.addGlobalMeta("Radiopharmaceutical", radioPharmaceutical);
        this.addGlobalMeta("Gantry tilt", gantryTilt);
        this.addGlobalMeta("Gantry rotation", gantryRotation);
        this.addGlobalMeta("Bed elevation", bedElevation);
        this.addGlobalMeta("Intrinsic tilt", intrinsicTilt);
        this.addGlobalMeta("Wobble speed", wobbleSpeed);
        this.addGlobalMeta("Source type", sourceType);
        this.addGlobalMeta("Distance scanned", distanceScanned);
        this.addGlobalMeta("Transaxial FOV", transaxialFOV);
        this.addGlobalMeta("Angular compression", angularCompression);
        this.addGlobalMeta("Coin. sample mode", coinSampleMode);
        this.addGlobalMeta("Axial sample mode", axialSampleMode);
        this.addGlobalMeta("Calibration factor", calibrationFactor);
        this.addGlobalMeta("Calibration units", calibrationUnits);
        this.addGlobalMeta("Calibration units label", calibrationLabel);
        this.addGlobalMeta("Compression", compression);
        this.addGlobalMeta("Study type", studyType);
        this.addGlobalMeta("Patient ID", patientID);
        this.addGlobalMeta("Patient name", patientName);
        this.addGlobalMeta("Patient sex", patientSex);
        this.addGlobalMeta("Patient dexterity", patientDexterity);
        this.addGlobalMeta("Patient age", patientAge);
        this.addGlobalMeta("Patient height", patientHeight);
        this.addGlobalMeta("Patient weight", patientWeight);
        this.addGlobalMeta("Patient birth date", patientBirthDate);
        this.addGlobalMeta("Physician name", physicianName);
        this.addGlobalMeta("Operator name", operatorName);
        this.addGlobalMeta("Description", description);
        this.addGlobalMeta("Acquisition type", acquisitionType);
        this.addGlobalMeta("Patient orientation", patientOrientation);
        this.addGlobalMeta("Facility name", facilityName);
        this.addGlobalMeta("Number of gates", numGates);
        this.addGlobalMeta("Number of bed positions", numBedPositions);
        for (float bedPos : bedPositions) {
            this.addGlobalMetaList("Bed position", Float.valueOf(bedPos));
        }
        this.addGlobalMeta("Plane separation", planeSeparation);
        this.addGlobalMeta("Lower threshold", lowerThreshold);
        this.addGlobalMeta("True lower threshold", trueLowerThreshold);
        this.addGlobalMeta("True upper threshold", trueUpperThreshold);
        this.addGlobalMeta("Process code", processCode);
        this.addGlobalMeta("Acquistion mode", acquisitionMode);
        this.addGlobalMeta("Bin size", binSize);
        this.addGlobalMeta("Branching fraction", branchingFraction);
        this.addGlobalMeta("Dose start time", doseStartTime);
        this.addGlobalMeta("Dosage", dosage);
        this.addGlobalMeta("Well counter correction factor", wellCounterCorrectionFactor);
        this.addGlobalMeta("Data units", dataUnits);
        this.addGlobalMeta("Septa state", septaState);
        short[] sArray = fillCTI;
        int n2 = sArray.length;
        for (n = 0; n < n2; ++n) {
            float fill = sArray[n];
            this.addGlobalMetaList("Fill CTI", Float.valueOf(fill));
        }
        this.addGlobalMeta("Data type", dataType);
        this.addGlobalMeta("Number of dimensions", numDimensions);
        this.addGlobalMeta("X offset", xOffset);
        this.addGlobalMeta("Y offset", yOffset);
        this.addGlobalMeta("Z offset", zOffset);
        this.addGlobalMeta("Recon. zoom", reconZoom);
        this.addGlobalMeta("Scale factor", scaleFactor);
        this.addGlobalMeta("Image minimum", imageMin);
        this.addGlobalMeta("Image maximum", imageMax);
        this.addGlobalMeta("X pixel size", xPixelSize);
        this.addGlobalMeta("Y pixel size", yPixelSize);
        this.addGlobalMeta("Z pixel size", zPixelSize);
        this.addGlobalMeta("Frame duration", frameDuration);
        this.addGlobalMeta("Frame start time", frameStartTime);
        this.addGlobalMeta("Filter code", filterCode);
        this.addGlobalMeta("X resolution", xResolution);
        this.addGlobalMeta("Y resolution", yResolution);
        this.addGlobalMeta("Z resolution", zResolution);
        this.addGlobalMeta("Number of R elements", numRElements);
        this.addGlobalMeta("Number of angles", numAngles);
        this.addGlobalMeta("Z rotation angle", zRotationAngle);
        this.addGlobalMeta("Decay correction factor", decayCorrectionFactor);
        this.addGlobalMeta("Processing code", processingCode);
        this.addGlobalMeta("Gate duration", gateDuration);
        this.addGlobalMeta("R wave offset", rWaveOffset);
        this.addGlobalMeta("Number of accepted beats", numAcceptedBeats);
        this.addGlobalMeta("Filter cutoff frequency", filterCutoffFrequency);
        this.addGlobalMeta("Filter resolution", filterResolution);
        this.addGlobalMeta("Filter ramp slope", filterRampSlope);
        this.addGlobalMeta("Filter order", filterOrder);
        this.addGlobalMeta("Filter scatter fraction", filterScatterFraction);
        this.addGlobalMeta("Filter scatter slope", filterScatterSlope);
        this.addGlobalMeta("Annotation", annotation);
        boolean bl2 = false;
        while (var108_117 < matrix.length) {
            for (j = 0; j < matrix[var108_117].length; ++j) {
                this.addGlobalMeta("MT (" + (int)(var108_117 + true) + ", " + (j + 1) + ")", matrix[var108_117][j]);
            }
            ++var108_117;
        }
        this.addGlobalMeta("R filter cutoff", rFilterCutoff);
        this.addGlobalMeta("R filter resolution", rFilterResolution);
        this.addGlobalMeta("R filter code", rFilterCode);
        this.addGlobalMeta("R filter order", rFilterOrder);
        this.addGlobalMeta("Z filter cutoff", zFilterCutoff);
        this.addGlobalMeta("Z filter resolution", zFilterResolution);
        this.addGlobalMeta("Z filter code", zFilterCode);
        this.addGlobalMeta("Z filter order", zFilterOrder);
        this.addGlobalMeta("Scatter type", scatterType);
        this.addGlobalMeta("Recon. type", reconType);
        this.addGlobalMeta("Recon. views", reconViews);
        short[] sArray2 = ctiFill;
        j = sArray2.length;
        for (n = 0; n < j; ++n) {
            float cti = sArray2[n];
            this.addGlobalMeta("CTI fill", cti);
        }
        short[] sArray3 = userFill;
        j = sArray3.length;
        for (n = 0; n < j; ++n) {
            float user = sArray3[n];
            this.addGlobalMeta("User fill", user);
        }
        MetadataStore metadataStore = this.makeFilterMetadata();
        MetadataTools.populatePixels(metadataStore, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            metadataStore.setImageDescription(description, 0);
            Length sizeX = FormatTools.getPhysicalSizeX(Double.valueOf(xPixelSize));
            Length sizeY = FormatTools.getPhysicalSizeY(Double.valueOf(yPixelSize));
            Length sizeZ = FormatTools.getPhysicalSizeZ(Double.valueOf(zPixelSize));
            if (sizeX != null) {
                metadataStore.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                metadataStore.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                metadataStore.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }
}

