/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.io.UnsupportedEncodingException;
import loci.poi.hssf.record.ContinueRecord;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.TextObjectBaseRecord;
import loci.poi.hssf.usermodel.HSSFRichTextString;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class TextObjectRecord
extends TextObjectBaseRecord {
    HSSFRichTextString str;

    public TextObjectRecord() {
    }

    public TextObjectRecord(RecordInputStream in) {
        super(in);
        if (this.str == null) {
            this.str = new HSSFRichTextString("");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        super.fillFields(in);
        if (this.getTextLength() > 0) {
            if (in.isContinueNext() && in.remaining() == 0) {
                in.nextRecord();
                this.processRawString(in);
            } else {
                throw new RecordFormatException("Expected Continue record to hold string data for TextObjectRecord");
            }
        }
        if (this.getFormattingRunLength() > 0) {
            if (in.isContinueNext() && in.remaining() == 0) {
                in.nextRecord();
                this.processFontRuns(in);
            } else {
                throw new RecordFormatException("Expected Continue Record to hold font runs for TextObjectRecord");
            }
        }
    }

    @Override
    public int getRecordSize() {
        int continue1Size = 0;
        int continue2Size = 0;
        if (this.str.length() != 0) {
            int length = this.str.length() * 2;
            while (length > 0) {
                int chunkSize = Math.min(8222, length);
                length -= chunkSize;
                continue1Size += chunkSize;
                continue1Size += 5;
            }
            continue2Size = (this.str.numFormattingRuns() + 1) * 8 + 4;
        }
        return super.getRecordSize() + continue1Size + continue2Size;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        HSSFRichTextString temp = this.str;
        this.str = new HSSFRichTextString("");
        int bytesWritten1 = super.serialize(offset, data);
        this.str = temp;
        int pos = offset + bytesWritten1;
        if (!this.str.getString().equals("")) {
            ContinueRecord c2 = this.createContinue2();
            int bytesWritten2 = 0;
            try {
                byte[] c1Data = this.str.getString().getBytes("UTF-16LE");
                int length = c1Data.length;
                int charsWritten = 0;
                int spos = pos;
                while (length > 0) {
                    int chunkSize = Math.min(8222, length);
                    length -= chunkSize;
                    LittleEndian.putShort(data, spos, (short)60);
                    LittleEndian.putShort(data, spos += 2, (short)(chunkSize + 1));
                    data[spos += 2] = 1;
                    System.arraycopy(c1Data, charsWritten, data, ++spos, chunkSize);
                    spos += chunkSize;
                    charsWritten += chunkSize;
                }
                bytesWritten2 = spos - pos;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            int bytesWritten3 = c2.serialize(pos += bytesWritten2, data);
            pos += bytesWritten3;
            int size = bytesWritten1 + bytesWritten2 + bytesWritten3;
            if (size != this.getRecordSize()) {
                throw new RecordFormatException(size + " bytes written but getRecordSize() reports " + this.getRecordSize());
            }
            return size;
        }
        if (bytesWritten1 != this.getRecordSize()) {
            throw new RecordFormatException(bytesWritten1 + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return bytesWritten1;
    }

    private ContinueRecord createContinue2() {
        ContinueRecord c2 = new ContinueRecord();
        byte[] c2Data = new byte[this.str.numFormattingRuns() * 8 + 8];
        int pos = 0;
        for (int i = 0; i < this.str.numFormattingRuns(); ++i) {
            LittleEndian.putShort(c2Data, pos, (short)this.str.getIndexOfFormattingRun(i));
            LittleEndian.putShort(c2Data, pos += 2, this.str.getFontOfFormattingRun(i) == 0 ? (short)0 : this.str.getFontOfFormattingRun(i));
            pos += 2;
            pos += 4;
        }
        LittleEndian.putShort(c2Data, pos, (short)this.str.length());
        LittleEndian.putShort(c2Data, pos += 2, (short)0);
        pos += 2;
        pos += 4;
        c2.setData(c2Data);
        return c2;
    }

    private void processFontRuns(RecordInputStream in) {
        while (in.remaining() > 0) {
            short index = in.readShort();
            short iFont = in.readShort();
            in.readInt();
            this.str.applyFont((int)index, this.str.length(), iFont);
        }
    }

    private void processRawString(RecordInputStream in) {
        byte compressByte = in.readByte();
        boolean isCompressed = compressByte == 0;
        String s2 = isCompressed ? in.readCompressedUnicode(this.getTextLength()) : in.readUnicodeLEString(this.getTextLength());
        this.str = new HSSFRichTextString(s2);
    }

    public HSSFRichTextString getStr() {
        return this.str;
    }

    public void setStr(HSSFRichTextString str) {
        this.str = str;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TXO]\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        buffer.append("         .HorizontalTextAlignment     = ").append(this.getHorizontalTextAlignment()).append('\n');
        buffer.append("         .VerticalTextAlignment     = ").append(this.getVerticalTextAlignment()).append('\n');
        buffer.append("         .reserved2                = ").append(this.getReserved2()).append('\n');
        buffer.append("         .textLocked               = ").append(this.isTextLocked()).append('\n');
        buffer.append("         .reserved3                = ").append(this.getReserved3()).append('\n');
        buffer.append("    .textOrientation      = ").append("0x").append(HexDump.toHex(this.getTextOrientation())).append(" (").append(this.getTextOrientation()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved4            = ").append("0x").append(HexDump.toHex(this.getReserved4())).append(" (").append(this.getReserved4()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved5            = ").append("0x").append(HexDump.toHex(this.getReserved5())).append(" (").append(this.getReserved5()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved6            = ").append("0x").append(HexDump.toHex(this.getReserved6())).append(" (").append(this.getReserved6()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved7            = ").append("0x").append(HexDump.toHex(this.getReserved7())).append(" (").append(this.getReserved7()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .string = ").append(this.str).append('\n');
        buffer.append("[/TXO]\n");
        return buffer.toString();
    }
}

