/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteLongTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)64L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.writeLong(1L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(0xFFFFFFFFFFFFF02L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(3L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(0xFFFFFFFFFFFFF04L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(5L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)40L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(-1L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)48L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(7L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)56L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(-2L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)64L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF04L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)5L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)-1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)7L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)-2L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        this.fileHandle.writeLong(0xFFFFFFFFFFFFF02L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(3L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.writeLong(1L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeLong(0xFFFFFFFFFFFFF02L);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        this.fileHandle.seek(0L);
        this.fileHandle.writeLong(1L);
        this.fileHandle.writeLong(0xFFFFFFFFFFFFF02L);
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
    }
}

