/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.DateFormat;
import io.minio.errors.InvalidArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class CopyConditions {
    private static final String METADATA_DIRECTIVE_REPLACE = "REPLACE";
    private Map<String, String> copyConditions = new HashMap<String, String>();

    public void setModified(DateTime date) throws InvalidArgumentException {
        if (date == null) {
            throw new InvalidArgumentException("Date cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-modified-since", date.toString(DateFormat.HTTP_HEADER_DATE_FORMAT));
    }

    public void setUnmodified(DateTime date) throws InvalidArgumentException {
        if (date == null) {
            throw new InvalidArgumentException("Date can not be null");
        }
        this.copyConditions.put("x-amz-copy-source-if-unmodified-since", date.toString(DateFormat.HTTP_HEADER_DATE_FORMAT));
    }

    public void setMatchETag(String etag) throws InvalidArgumentException {
        if (etag == null) {
            throw new InvalidArgumentException("ETag cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-match", etag);
    }

    public void setMatchETagNone(String etag) throws InvalidArgumentException {
        if (etag == null) {
            throw new InvalidArgumentException("ETag cannot be empty");
        }
        this.copyConditions.put("x-amz-copy-source-if-none-match", etag);
    }

    public void setReplaceMetadataDirective() {
        this.copyConditions.put("x-amz-metadata-directive", METADATA_DIRECTIVE_REPLACE);
    }

    public Map<String, String> getConditions() {
        return Collections.unmodifiableMap(this.copyConditions);
    }
}

