/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteDoubleTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)56L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.writeDouble(0.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(1.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(-1.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(Math.PI);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(Double.MAX_VALUE);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)40L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(Double.NEGATIVE_INFINITY);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)48L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(Double.NaN);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)56L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)0.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)-1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Math.PI, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.MAX_VALUE, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.NaN, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.writeDouble(-1.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(Math.PI);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((Object)-1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Math.PI, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.writeDouble(0.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeDouble(1.0);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)0.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)1.0, (Object)this.fileHandle.readDouble());
        this.fileHandle.seek(0L);
        this.fileHandle.writeDouble(-1.0);
        this.fileHandle.writeDouble(Math.PI);
        this.fileHandle.seek(0L);
        this.fileHandle.writeDouble(-1.0);
        this.fileHandle.writeDouble(Math.PI);
    }
}

