/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.ZipException;
import loci.formats.FormatException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.NikonCodecOptions;
import loci.formats.tiff.TiffCompression;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TiffCompressionDecompressTest {
    private static final byte[] DATA = new byte[64];
    private static final CodecOptions OPTIONS = new CodecOptions();

    @Test
    public void testUNCOMPRESSED() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.UNCOMPRESSED;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={FormatException.class})
    public void testCCITT_1D() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.CCITT_1D;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_3_FAX() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.GROUP_3_FAX;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_4_FAX() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.GROUP_3_FAX;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test
    public void testLZW() throws FormatException, IOException {
        block2: {
            TiffCompression compression = TiffCompression.LZW;
            try {
                AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
            }
            catch (FormatException e) {
                if (e.getCause() instanceof EOFException) break block2;
                AssertJUnit.fail((String)("Unexpected exception: " + (Object)((Object)e)));
            }
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testJPEG() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test
    public void testPACK_BITS() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.PACK_BITS;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test
    public void testPROPRIETARY_DEFLATE() throws FormatException, IOException {
        block2: {
            TiffCompression compression = TiffCompression.PROPRIETARY_DEFLATE;
            try {
                AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
            }
            catch (FormatException e) {
                if (e.getCause() instanceof ZipException) break block2;
                AssertJUnit.fail((String)("Unexpected exception: " + (Object)((Object)e)));
            }
        }
    }

    @Test
    public void testDEFLATE() throws FormatException, IOException {
        block2: {
            TiffCompression compression = TiffCompression.DEFLATE;
            try {
                AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
            }
            catch (FormatException e) {
                if (e.getCause() instanceof ZipException) break block2;
                AssertJUnit.fail((String)("Unexpected exception: " + (Object)((Object)e)));
            }
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testTHUNDERSCAN() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.THUNDERSCAN;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testJPEG_2000() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testJPEG_2000_LOSSY() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000_LOSSY;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testALT_JPEG() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.ALT_JPEG;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, OPTIONS));
    }

    @Test
    public void testNIKON() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.NIKON;
        NikonCodecOptions options = new NikonCodecOptions();
        options.interleaved = TiffCompressionDecompressTest.OPTIONS.interleaved;
        options.littleEndian = TiffCompressionDecompressTest.OPTIONS.littleEndian;
        options.maxBytes = TiffCompressionDecompressTest.OPTIONS.maxBytes;
        options.curve = new int[]{1};
        options.vPredictor = new int[]{1};
        options.lossless = true;
        options.split = 1;
        AssertJUnit.assertNotNull((Object)compression.decompress(DATA, (CodecOptions)options));
    }

    static {
        TiffCompressionDecompressTest.OPTIONS.width = 8;
        TiffCompressionDecompressTest.OPTIONS.height = 8;
        TiffCompressionDecompressTest.OPTIONS.bitsPerSample = 8;
        TiffCompressionDecompressTest.OPTIONS.interleaved = true;
        TiffCompressionDecompressTest.OPTIONS.littleEndian = true;
        TiffCompressionDecompressTest.OPTIONS.maxBytes = DATA.length;
    }
}

