/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.analysis.PolynomialFunctionLagrangeForm;
import org.apache.commons.math.analysis.PolynomialFunctionNewtonForm;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealInterpolator;

public class DividedDifferenceInterpolator
implements UnivariateRealInterpolator,
Serializable {
    private static final long serialVersionUID = 107049519551235069L;

    public UnivariateRealFunction interpolate(double[] x, double[] y) throws DuplicateSampleAbscissaException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        double[] c = new double[x.length - 1];
        for (int i = 0; i < c.length; ++i) {
            c[i] = x[i];
        }
        double[] a = DividedDifferenceInterpolator.computeDividedDifference(x, y);
        PolynomialFunctionNewtonForm p = new PolynomialFunctionNewtonForm(a, c);
        return p;
    }

    protected static double[] computeDividedDifference(double[] x, double[] y) throws DuplicateSampleAbscissaException {
        int i;
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        int n = x.length;
        double[] divdiff = new double[n];
        for (i = 0; i < n; ++i) {
            divdiff[i] = y[i];
        }
        double[] a = new double[n];
        a[0] = divdiff[0];
        for (i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double denominator = x[j + i] - x[j];
                if (denominator == 0.0) {
                    throw new DuplicateSampleAbscissaException(x[j], j, j + i);
                }
                divdiff[j] = (divdiff[j + 1] - divdiff[j]) / denominator;
            }
            a[i] = divdiff[0];
        }
        return a;
    }
}

