/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.storage;

import com.bc.zarr.ZarrUtils;
import com.bc.zarr.storage.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystemStore
implements Store {
    private final Path internalRoot;

    public FileSystemStore(String path, FileSystem fileSystem) {
        this.internalRoot = fileSystem == null ? Paths.get(path, new String[0]) : fileSystem.getPath(path, new String[0]);
    }

    public FileSystemStore(Path rootPath) {
        this.internalRoot = rootPath;
    }

    @Override
    public InputStream getInputStream(String key) throws IOException {
        Path path = this.internalRoot.resolve(key);
        if (Files.isReadable(path)) {
            byte[] bytes = Files.readAllBytes(path);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(final String key) {
        return new ByteArrayOutputStream(){
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                try {
                    if (!this.closed) {
                        byte[] bytes = this.toByteArray();
                        Path filePath = FileSystemStore.this.internalRoot.resolve(key);
                        if (Files.exists(filePath, new LinkOption[0])) {
                            Files.delete(filePath);
                        } else {
                            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                        }
                        Files.write(filePath, bytes, new OpenOption[0]);
                    }
                }
                finally {
                    this.closed = true;
                }
            }
        };
    }

    @Override
    public void delete(String key) throws IOException {
        Path toBeDeleted = this.internalRoot.resolve(key);
        if (Files.isDirectory(toBeDeleted, new LinkOption[0])) {
            ZarrUtils.deleteDirectoryTreeRecursively(toBeDeleted);
        }
        if (Files.exists(toBeDeleted, new LinkOption[0])) {
            Files.delete(toBeDeleted);
        }
        if (Files.exists(toBeDeleted, new LinkOption[0]) || Files.isDirectory(toBeDeleted, new LinkOption[0])) {
            throw new IOException("Unable to initialize " + toBeDeleted.toAbsolutePath().toString());
        }
    }

    @Override
    public TreeSet<String> getArrayKeys() throws IOException {
        return this.getParentsOf(".zarray");
    }

    @Override
    public TreeSet<String> getGroupKeys() throws IOException {
        return this.getParentsOf(".zgroup");
    }

    private TreeSet<String> getParentsOf(String suffix) throws IOException {
        return this.getKeysEndingWith(suffix).stream().map(s2 -> this.internalRoot.relativize(this.internalRoot.resolve((String)s2).getParent()).toString()).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public TreeSet<String> getKeysEndingWith(String suffix) throws IOException {
        return Files.walk(this.internalRoot, new FileVisitOption[0]).filter(path -> path.toString().endsWith(suffix)).map(path -> this.internalRoot.relativize((Path)path).toString()).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Stream<String> getRelativeLeafKeys(String key) throws IOException {
        Path walkingRoot = this.internalRoot.resolve(key);
        return Files.walk(walkingRoot, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> walkingRoot.relativize((Path)path).toString()).map(ZarrUtils::normalizeStoragePath).filter(s2 -> s2.trim().length() > 0);
    }
}

