/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import loci.formats.ClassList;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassListTest {
    private ClassList<Iterable> c;
    String configFile;

    public String writeConfigFile(String content) throws IOException {
        File file = File.createTempFile("iterables", ".tmp");
        file.deleteOnExit();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(content);
        bw.close();
        return file.getAbsolutePath();
    }

    @Test
    public void testDefaultConstructor() {
        this.c = new ClassList(Iterable.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
    }

    @Test
    public void testNullConstructor() throws IOException {
        this.c = new ClassList(null, Iterable.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
    }

    @Test
    public void testConfigFileConstructor1() throws IOException {
        this.configFile = this.writeConfigFile("java.util.ArrayList\njava.util.AbstractList");
        this.c = new ClassList(this.configFile, Iterable.class, null);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], ArrayList.class);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[1], AbstractList.class);
    }

    @Test
    public void testConfigFileConstructor2() throws IOException {
        this.c = new ClassList("iterables.txt", Iterable.class, ClassListTest.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], AbstractList.class);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[1], ArrayList.class);
    }

    @Test
    public void testInvalidFileConstructor1() throws IOException {
        this.c = new ClassList("invalid", Iterable.class, null);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
    }

    @Test
    public void testInvalidFileConstructor2() throws IOException {
        this.c = new ClassList("invalid", Iterable.class, ClassListTest.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
    }

    @Test
    public void testParseFile() throws IOException {
        this.c = new ClassList(null, Iterable.class);
        this.c.parseFile("iterables.txt", ClassListTest.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
    }

    @Test
    public void testAddClass() {
        this.c = new ClassList(Iterable.class);
        this.c.addClass(AbstractList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)1);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], AbstractList.class);
        this.c.addClass(ArrayList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[1], ArrayList.class);
        this.c.addClass(ArrayList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)3);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[2], ArrayList.class);
    }

    @Test
    public void testRemoveClass() throws IOException {
        this.c = new ClassList("iterables.txt", Iterable.class, ClassListTest.class);
        this.c.removeClass(AbstractList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)1);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], ArrayList.class);
        this.c.removeClass(ArrayList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
        this.c.removeClass(ArrayList.class);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
    }

    @Test
    public void testAppend() throws IOException {
        this.configFile = this.writeConfigFile("java.util.ArrayList");
        this.c = new ClassList(this.configFile, Iterable.class, null);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)1);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], ArrayList.class);
        String configFile2 = this.writeConfigFile("java.util.AbstractList");
        ClassList c2 = new ClassList(configFile2, Iterable.class, null);
        this.c.append(c2);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], ArrayList.class);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[1], AbstractList.class);
    }

    @Test
    public void testPrepend() throws IOException {
        this.configFile = this.writeConfigFile("java.util.ArrayList");
        this.c = new ClassList(this.configFile, Iterable.class, null);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)1);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], ArrayList.class);
        String configFile2 = this.writeConfigFile("java.util.AbstractList");
        ClassList c2 = new ClassList(configFile2, Iterable.class, null);
        this.c.prepend(c2);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)2);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], AbstractList.class);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[1], ArrayList.class);
    }

    @DataProvider(name="escaped lines")
    public Object[][] createEscapedLines() throws ClassNotFoundException {
        return new Object[][]{{""}, {"  # comment"}, {"# comment"}};
    }

    @Test(dataProvider="escaped lines")
    public void testParseEscapedLine(String line) throws IOException {
        this.c = new ClassList(null, Iterable.class);
        this.c.parseLine(line);
        AssertJUnit.assertEquals((int)this.c.getClasses().length, (int)0);
        AssertJUnit.assertTrue((boolean)this.c.getOptions().isEmpty());
    }

    @DataProvider(name="classes")
    public Object[][] createClassesNoOptions() throws ClassNotFoundException {
        return new Object[][]{{"java.util.ArrayList", ArrayList.class}, {"java.util.ArrayList  ", ArrayList.class}, {"java.util.ArrayList  # comment", ArrayList.class}};
    }

    @Test(dataProvider="classes")
    public void testParseClasses(String line, Object output) throws IOException {
        this.c = new ClassList(null, Iterable.class);
        this.c.parseLine(line);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], (Object)output);
        AssertJUnit.assertTrue((boolean)this.c.getOptions().isEmpty());
    }

    @DataProvider(name="classes with options")
    public Object[][] createClassesWithOptions() throws ClassNotFoundException {
        return new Object[][]{{"java.util.ArrayList[a=b]", ArrayList.class}, {"java.util.ArrayList[a=b]  ", ArrayList.class}, {"java.util.ArrayList[a=b]  # comment", ArrayList.class}};
    }

    @Test(dataProvider="classes with options")
    public void testParseClassesWithOptions(String line, Object output) throws IOException {
        this.c = new ClassList(null, Iterable.class);
        this.c.parseLine(line);
        AssertJUnit.assertEquals((Object)this.c.getClasses()[0], (Object)output);
        AssertJUnit.assertEquals((int)this.c.getOptions().size(), (int)1);
        AssertJUnit.assertEquals((String)((String)this.c.getOptions().get("java.util.ArrayList.a")), (String)"b");
    }

    @Test
    public void testSetOption() throws IOException {
        this.c = new ClassList(null, Iterable.class);
        AssertJUnit.assertEquals(Collections.emptySet(), this.c.getOptions().keySet());
        this.c.addOption("a", "b");
        AssertJUnit.assertEquals(this.c.getOptions().keySet(), Collections.singleton("a"));
        AssertJUnit.assertEquals((String)((String)this.c.getOptions().get("a")), (String)"b");
    }

    @DataProvider(name="option string")
    public Object[][] createOptionStrings() {
        return new Object[][]{{"a", new HashMap()}, {"a,b", new HashMap()}, {"=", new HashMap()}, {"", new HashMap()}, {"a=", new HashMap()}, {"=b", new HashMap()}, {"a=b", new HashMap<String, String>(){
            {
                this.put("a", "b");
            }
        }}, {"a=b,c=d", new HashMap<String, String>(){
            {
                this.put("a", "b");
                this.put("c", "d");
            }
        }}, {"a=b,a=b", new HashMap<String, String>(){
            {
                this.put("a", "b");
            }
        }}, {"a=b,c", new HashMap<String, String>(){
            {
                this.put("a", "b");
            }
        }}, {"a=b,=,c=d", new HashMap<String, String>(){
            {
                this.put("a", "b");
                this.put("c", "d");
            }
        }}};
    }

    @Test(dataProvider="option string")
    public void testParseOptions(String options, HashMap map) throws IOException {
        this.c = new ClassList(null, Iterable.class);
        AssertJUnit.assertEquals((Object)map, (Object)this.c.parseOptions(options));
    }

    @Test
    public void testAllowedKeys() throws IOException {
        this.c = new ClassList(null, Iterable.class);
        AssertJUnit.assertTrue((boolean)this.c.isAllowedKey("type"));
        AssertJUnit.assertTrue((boolean)this.c.isAllowedKey("package.name.type"));
        AssertJUnit.assertTrue((boolean)this.c.isAllowedKey("type"));
        AssertJUnit.assertFalse((boolean)this.c.isAllowedKey("type.subtype"));
        AssertJUnit.assertFalse((boolean)this.c.isAllowedKey(""));
        AssertJUnit.assertFalse((boolean)this.c.isAllowedKey("."));
    }
}

