/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.adobe.internal.xmp.XMPMeta;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import loci.common.RandomAccessInputStream;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.formats.services.EXIFService;

public class EXIFServiceImpl
extends AbstractService
implements EXIFService {
    private ExifSubIFDDirectory directory;

    public EXIFServiceImpl() {
        this.checkClassDependency(ImageMetadataReader.class);
        this.checkClassDependency(XMPMeta.class);
    }

    @Override
    public void initialize(String file2) throws ServiceException, IOException {
        try (RandomAccessInputStream jpegFile = new RandomAccessInputStream(file2);){
            try {
                Metadata metadata = ImageMetadataReader.readMetadata(jpegFile);
                this.directory = metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
            }
            catch (Throwable e) {
                throw new ServiceException("Could not read EXIF data", e);
            }
        }
    }

    @Override
    public HashMap<String, String> getTags() {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        if (this.directory != null) {
            for (Tag tag : this.directory.getTags()) {
                tagMap.put(tag.getTagName(), tag.getDescription());
            }
        }
        return tagMap;
    }

    @Override
    public Date getCreationDate() {
        if (this.directory != null) {
            return this.directory.getDate(36867);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.directory = null;
    }
}

