/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteUTFTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)10L, (long)this.fileHandle.length());
    }

    @Test
    public void testWriteSequential() throws IOException {
        this.fileHandle.writeUTF("\u00a9");
        this.fileHandle.writeUTF("\u2260");
        this.fileHandle.writeUTF("\u00a9");
        this.fileHandle.writeUTF("\u2260");
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)2, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)3, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-30, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-119, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-96, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)2, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)3, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-30, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-119, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-96, (byte)this.fileHandle.readByte());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((String)"\u00a9", (String)this.fileHandle.readUTF());
        AssertJUnit.assertEquals((String)"\u2260", (String)this.fileHandle.readUTF());
        AssertJUnit.assertEquals((String)"\u00a9", (String)this.fileHandle.readUTF());
        AssertJUnit.assertEquals((String)"\u2260", (String)this.fileHandle.readUTF());
    }

    @Test
    public void testWrite() throws IOException {
        this.fileHandle.writeUTF("\u00a9\n");
        AssertJUnit.assertEquals((long)5L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)3, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((String)"\u00a9\n", (String)this.fileHandle.readUTF());
    }

    @Test
    public void testWriteTwoCharacters() throws IOException {
        this.fileHandle.seek(0L);
        this.fileHandle.writeUTF("\u00a9\u2260");
        AssertJUnit.assertEquals((long)7L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)5, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((String)"\u00a9\u2260", (String)this.fileHandle.readUTF());
    }

    @Test
    public void testWriteOffEnd() throws IOException {
        this.fileHandle.seek(10L);
        this.fileHandle.writeUTF("\u00a9");
        AssertJUnit.assertEquals((long)14L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)14L, (long)this.fileHandle.length());
        this.fileHandle.seek(10L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)2, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        this.fileHandle.seek(10L);
        AssertJUnit.assertEquals((String)"\u00a9", (String)this.fileHandle.readUTF());
    }

    @Test
    public void testWriteTwiceOffEnd() throws IOException {
        this.fileHandle.seek(10L);
        this.fileHandle.writeUTF("\u00a9");
        this.fileHandle.writeUTF("\u2260");
        AssertJUnit.assertEquals((long)19L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)19L, (long)this.fileHandle.length());
        this.fileHandle.seek(10L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)2, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-62, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-87, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)3, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-30, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-119, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)-96, (byte)this.fileHandle.readByte());
        this.fileHandle.seek(10L);
        AssertJUnit.assertEquals((String)"\u00a9", (String)this.fileHandle.readUTF());
        AssertJUnit.assertEquals((String)"\u2260", (String)this.fileHandle.readUTF());
    }
}

