/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexLong;
import ucar.nc2.iosp.Layout;

public class IndexChunker {
    private static final boolean debug = false;
    private static final boolean debugMerge = false;
    private static final boolean debugNext = false;
    private List<Dim> dimList = new ArrayList<Dim>();
    private IndexLong chunkIndex;
    private Chunk chunk;
    private int nelems;
    private long start;
    private long total;
    private long done;

    public IndexChunker(int[] srcShape, @Nullable Section wantSection) throws InvalidRangeException {
        Dim elem2;
        Dim elem;
        int i;
        wantSection = Section.fill(wantSection, srcShape);
        this.total = wantSection.computeSize();
        this.done = 0L;
        this.start = 0L;
        if (wantSection.equivalent(srcShape)) {
            this.nelems = (int)this.total;
            this.chunkIndex = new IndexLong();
            return;
        }
        int varRank = srcShape.length;
        long stride = 1L;
        for (int ii = varRank - 1; ii >= 0; --ii) {
            this.dimList.add(new Dim(stride, srcShape[ii], wantSection.getRange(ii)));
            stride *= (long)srcShape[ii];
        }
        int merge = 0;
        for (i = 0; i < this.dimList.size() - 1; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            if (elem.maxSize != (long)elem.wantSize || elem2.want.stride() != 1) break;
            ++merge;
        }
        for (i = 0; i < merge; ++i) {
            elem = this.dimList.get(i);
            elem2 = this.dimList.get(i + 1);
            elem2.maxSize *= elem.maxSize;
            elem2.wantSize *= elem.wantSize;
            if (elem2.wantSize >= 0) continue;
            throw new IllegalArgumentException("array size may not exceed 2^31");
        }
        if (merge > 0) {
            this.dimList.subList(0, merge).clear();
        }
        if (varRank == 0 || this.dimList.get((int)0).want.stride() > 1) {
            this.nelems = 1;
        } else {
            Dim innerDim = this.dimList.get(0);
            this.nelems = innerDim.wantSize;
            innerDim.wantSize = 1;
        }
        this.start = 0L;
        for (Dim dim : this.dimList) {
            this.start += dim.stride * (long)dim.want.first();
        }
        int rank = this.dimList.size();
        long[] wstride = new long[rank];
        int[] shape = new int[rank];
        for (int i2 = 0; i2 < rank; ++i2) {
            Dim dim = this.dimList.get(i2);
            wstride[rank - i2 - 1] = dim.stride * (long)dim.want.stride();
            shape[rank - i2 - 1] = dim.wantSize;
        }
        this.chunkIndex = new IndexLong(shape, wstride);
        assert (IndexLong.computeSize(shape) * (long)this.nelems == this.total);
    }

    public long getTotalNelems() {
        return this.total;
    }

    public boolean hasNext() {
        return this.done < this.total;
    }

    public Chunk next() {
        if (this.chunk == null) {
            this.chunk = new Chunk(this.start, this.nelems, 0L);
        } else {
            this.chunkIndex.incr();
            this.chunk.incrDestElem(this.nelems);
        }
        this.chunk.setSrcElem(this.start + this.chunkIndex.currentElement());
        this.done += (long)this.nelems;
        return this.chunk;
    }

    public String toString() {
        Dim elem;
        int i;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("wantSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.wantSize);
        }
        sbuff.append(" maxSize=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.maxSize);
        }
        sbuff.append(" wantStride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.want.stride());
        }
        sbuff.append(" stride=");
        for (i = 0; i < this.dimList.size(); ++i) {
            elem = this.dimList.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(elem.stride);
        }
        return sbuff.toString();
    }

    protected static String printa(int[] a) {
        StringBuilder sbuff = new StringBuilder();
        for (int anA : a) {
            sbuff.append(anA).append(" ");
        }
        return sbuff.toString();
    }

    protected static void printa(String name, int[] a) {
        System.out.print(name + "= ");
        for (int anA : a) {
            System.out.print(anA + " ");
        }
        System.out.println();
    }

    protected static void printl(String name, long[] a) {
        System.out.print(name + "= ");
        for (long anA : a) {
            System.out.print(anA + " ");
        }
        System.out.println();
    }

    public static class Chunk
    implements Layout.Chunk {
        private long srcElem;
        private int nelems;
        private long destElem;
        private long srcPos;

        public Chunk(long srcElem, int nelems, long destElem) {
            this.srcElem = srcElem;
            this.nelems = nelems;
            this.destElem = destElem;
        }

        public long getSrcElem() {
            return this.srcElem;
        }

        public void setSrcElem(long srcElem) {
            this.srcElem = srcElem;
        }

        public void incrSrcElem(int incr) {
            this.srcElem += (long)incr;
        }

        @Override
        public int getNelems() {
            return this.nelems;
        }

        public void setNelems(int nelems) {
            this.nelems = nelems;
        }

        @Override
        public long getDestElem() {
            return this.destElem;
        }

        public void setDestElem(long destElem) {
            this.destElem = destElem;
        }

        public void incrDestElem(int incr) {
            this.destElem += (long)incr;
        }

        public String toString() {
            return " srcPos=" + this.srcPos + " srcElem=" + this.srcElem + " nelems=" + this.nelems + " destElem=" + this.destElem;
        }

        @Override
        public long getSrcPos() {
            return this.srcPos;
        }

        public void setSrcPos(long srcPos) {
            this.srcPos = srcPos;
        }

        public void incrSrcPos(int incr) {
            this.srcPos += (long)incr;
        }
    }

    private static class Dim {
        long stride;
        long maxSize;
        Range want;
        int wantSize;

        Dim(long byteStride, int maxSize, Range want) {
            this.stride = byteStride;
            this.maxSize = maxSize;
            this.wantSize = want.length();
            this.want = want;
        }
    }
}

