/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.rc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RC {
    static boolean showlog;
    public static Logger log;
    public static final String USEGROUPSKEY = "ucar.nc2.cdm.usegroups";
    public static final String VERIFYSERVERKEY = "ucar.nc2.net.verifyserver";
    public static final String ALLOWSELFSIGNEDKEY = "ucar.nc2.net.allowselfsigned";
    protected static boolean useGroups;
    protected static boolean verifyServer;
    protected static boolean allowSelfSigned;
    static final String DFALTRCFILE = ".threddsrc";
    static final char LTAG = '[';
    static final char RTAG = ']';
    static final String[] rcfilelist;
    static RC dfaltRC;
    private static boolean initialized;
    Map<String, List<Triple>> triplestore = new HashMap<String, List<Triple>>();

    public static boolean getUseGroups() {
        if (!initialized) {
            RC.initialize();
        }
        return useGroups;
    }

    public static boolean getVerifyServer() {
        if (!initialized) {
            RC.initialize();
        }
        return verifyServer;
    }

    public static boolean getAllowSelfSigned() {
        if (!initialized) {
            RC.initialize();
        }
        return allowSelfSigned;
    }

    public static void set(String key, String value) {
        assert (key != null);
        switch (key) {
            case "ucar.nc2.cdm.usegroups": {
                useGroups = RC.booleanize(value);
                break;
            }
            case "ucar.nc2.net.verifyserver": {
                verifyServer = RC.booleanize(value);
                break;
            }
            case "ucar.nc2.net.allowselfsigned": {
                allowSelfSigned = RC.booleanize(value);
            }
        }
    }

    static boolean booleanize(String value) {
        if (value == null || "0".equals(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        if (value.isEmpty() || "1".equals(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        return value != null;
    }

    static int urlCompare(URL u1, URL u2) {
        String host2;
        if (u1 == null && u2 == null) {
            return 0;
        }
        if (u1 == null) {
            return -1;
        }
        if (u2 == null) {
            return 1;
        }
        String host1 = new StringBuilder(u1.getHost()).reverse().toString();
        int relation = host1.compareTo(host2 = new StringBuilder(u2.getHost()).reverse().toString());
        if (relation != 0) {
            return relation;
        }
        relation = u1.getPath().compareTo(u2.getPath());
        if (relation != 0) {
            return relation;
        }
        relation = u1.getPort() - u2.getPort();
        return relation;
    }

    static boolean urlMatch(URL pattern, URL url) {
        if (pattern == null) {
            return url == null;
        }
        if (!url.getHost().endsWith(pattern.getHost())) {
            return false;
        }
        if (!url.getPath().startsWith(pattern.getPath())) {
            return false;
        }
        return pattern.getPort() <= 0 || pattern.getPort() == url.getPort();
    }

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            RC.loadDefaults();
            RC.setWellKnown();
            RC.loadFromJava();
        }
    }

    public static synchronized void add(String key, String value, String url) {
        if (key == null) {
            return;
        }
        if (!initialized) {
            RC.initialize();
        }
        Triple t2 = new Triple(key, value, url);
        dfaltRC.insert(t2);
        RC.setWellKnown();
    }

    public static synchronized String find(String key, String url) {
        Triple t2;
        if (key == null) {
            return null;
        }
        if (!initialized) {
            RC.initialize();
        }
        return (t2 = dfaltRC.lookup(key, url)) == null ? null : t2.value;
    }

    static void setWellKnown() {
        if (RC.dfaltRC.triplestore.isEmpty()) {
            return;
        }
        for (String key : dfaltRC.keySet()) {
            Triple triple = dfaltRC.lookup(key);
            if (triple.url != null) continue;
            RC.set(key, triple.value);
        }
    }

    static void loadDefaults() {
        RC rc0 = new RC();
        String[] locations = new String[]{System.getProperty("user.home"), System.getProperty("user.dir")};
        boolean found1 = false;
        for (String loc : locations) {
            if (loc == null) continue;
            String dir = loc.replace('\\', '/');
            if (dir.endsWith("/")) {
                // empty if block
            }
            for (String rcpath : rcfilelist) {
                String filepath = loc + "/" + rcpath;
                if (!rc0.load(filepath)) continue;
                found1 = true;
            }
        }
        if (!found1 && showlog) {
            log.debug("No .rc file found");
        }
        dfaltRC = rc0;
    }

    static void loadFromJava() {
        String[] flags;
        for (String flag : flags = new String[]{USEGROUPSKEY, VERIFYSERVERKEY, ALLOWSELFSIGNEDKEY}) {
            String value = System.getProperty(flag);
            if (value == null) continue;
            RC.set(flag, value);
        }
    }

    static RC getDefault() {
        return dfaltRC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(String abspath) {
        File rcFile = new File(abspath = abspath.replace('\\', '/'));
        if (!rcFile.exists()) return false;
        if (!rcFile.canRead()) {
            return false;
        }
        if (showlog) {
            log.debug("Loading rc file: " + abspath);
        }
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rcFile), StandardCharsets.UTF_8));){
            int lineno = 1;
            while (true) {
                URL url = null;
                String line = rdr.readLine();
                if (line == null) {
                    return true;
                }
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    if (line.charAt(0) == '[') {
                        int rindex;
                        block22: {
                            rindex = line.indexOf(93);
                            if (rindex < 0) {
                                boolean bl = false;
                                return bl;
                            }
                            if (showlog) {
                                log.error("Malformed [url] at " + abspath + "." + lineno);
                            }
                            String surl = line.substring(1, rindex);
                            try {
                                url = new URL(surl);
                            }
                            catch (MalformedURLException mue) {
                                if (!showlog) break block22;
                                log.error("Malformed [url] at " + abspath + "." + lineno);
                            }
                        }
                        line = line.substring(rindex + 1);
                        line = line.trim();
                    }
                    String[] pieces = line.split("\\s*=\\s*");
                    assert (pieces.length == 1 || pieces.length == 2);
                    String value = "1";
                    if (pieces.length == 2) {
                        value = pieces[1].trim();
                    }
                    Triple triple = new Triple(pieces[0].trim(), value, url);
                    List<Triple> list = this.triplestore.get(triple.key);
                    if (list == null) {
                        list = new ArrayList<Triple>();
                    }
                    Triple prev = this.addtriple(list, triple);
                    this.triplestore.put(triple.key, list);
                }
                ++lineno;
            }
        }
        catch (FileNotFoundException fe) {
            if (!showlog) return false;
            log.debug("Loading rc file: " + abspath);
            return false;
        }
        catch (IOException ioe) {
            if (!showlog) return false;
            log.error("File " + abspath + ": IO exception: " + ioe.getMessage());
            return false;
        }
    }

    public Set<String> keySet() {
        return this.triplestore.keySet();
    }

    public List<Triple> getTriples(String key) {
        List<Triple> list = this.triplestore.get(key);
        if (list == null) {
            list = new ArrayList<Triple>();
        }
        return list;
    }

    public Triple lookup(String key) {
        return this.lookup(key, (URL)null);
    }

    public Triple lookup(String key, String url) {
        if (url == null || url.isEmpty()) {
            return this.lookup(key);
        }
        try {
            URL u = new URL(url);
            return this.lookup(key, u);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Triple lookup(String key, URL url) {
        List<Triple> list = this.triplestore.get(key);
        if (list == null) {
            return null;
        }
        if (url == null) {
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        for (Triple t2 : list) {
            if (!RC.urlMatch(t2.url, url)) continue;
            return t2;
        }
        return null;
    }

    Triple addtriple(List<Triple> list, Triple triple) {
        Triple prev = null;
        assert (list != null);
        int i = list.indexOf(triple);
        if (i >= 0) {
            prev = list.remove(i);
        }
        list.add(triple);
        Collections.sort(list);
        return prev;
    }

    public Triple insert(Triple t2) {
        if (t2.key == null) {
            return null;
        }
        List<Triple> list = this.triplestore.get(t2.key);
        if (list == null) {
            list = new ArrayList<Triple>();
        }
        Triple prev = this.addtriple(list, t2);
        this.triplestore.put(t2.key, list);
        return prev;
    }

    public String toString() {
        StringBuilder rc = new StringBuilder();
        for (String key : this.keySet()) {
            List<Triple> list = this.getTriples(key);
            for (Triple triple : list) {
                String line = triple.toString();
                rc.append(line);
                rc.append("\n");
            }
        }
        return rc.toString();
    }

    static {
        log = LoggerFactory.getLogger(RC.class);
        useGroups = true;
        allowSelfSigned = true;
        rcfilelist = new String[]{".dodsrc", ".tdsrc"};
        RC.initialize();
    }

    public static class Triple
    implements Comparable<Triple> {
        public String key;
        public String value;
        public URL url;

        public Triple(String key, String value, String url) {
            URL u = null;
            if (url != null && !url.isEmpty()) {
                try {
                    u = new URL(url);
                }
                catch (MalformedURLException e) {
                    u = null;
                }
            }
            this.set(key, value, u);
        }

        public Triple(String key, String value, URL url) {
            this.set(key, value, url);
        }

        void set(String key, String value, URL url) {
            this.key = key.trim().toLowerCase();
            this.url = url;
            this.value = value;
            if (this.value == null) {
                this.value = "";
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Triple)) {
                return false;
            }
            return this.compareTo((Triple)o) == 0;
        }

        @Override
        public int compareTo(Triple t2) {
            if (t2 == null) {
                throw new NullPointerException();
            }
            int relation = this.key.compareTo(t2.key);
            if (relation != 0) {
                return relation;
            }
            relation = RC.urlCompare(this.url, t2.url);
            return relation;
        }

        public String toString() {
            StringBuilder line = new StringBuilder();
            if (this.url != null) {
                line.append("[");
                line.append(this.url);
                line.append("]");
            }
            line.append(this.key);
            line.append("=");
            line.append(this.value);
            return line.toString();
        }
    }
}

