/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.filter;

import io.airlift.compress.lz4.Lz4Decompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class LZ4Filter
extends Filter {
    static final String name = "LZ4 filter";
    static final int id = 32004;
    private Lz4Decompressor decompressor = new Lz4Decompressor();

    public LZ4Filter(Map<String, Object> properties) {
    }

    public String getName() {
        return name;
    }

    public int getId() {
        return 32004;
    }

    public byte[] encode(byte[] dataIn) throws IOException {
        throw new UnsupportedOperationException("LZ4Filter does not support data compression");
    }

    public byte[] decode(byte[] dataIn) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(dataIn);
        long totalDecompressedSize = byteBuffer.getLong();
        int decompressedBlockSize = byteBuffer.getInt();
        int compressedBlockSize = byteBuffer.getInt();
        byte[] decompressedBlock = new byte[Math.toIntExact(totalDecompressedSize)];
        byte[] compressedBlock = new byte[compressedBlockSize];
        byteBuffer.get(compressedBlock, 0, compressedBlockSize);
        this.decompressor.decompress(compressedBlock, 0, compressedBlockSize, decompressedBlock, 0, decompressedBlockSize);
        return decompressedBlock;
    }

    public static class LZ4FilterProvider
    implements FilterProvider {
        public String getName() {
            return LZ4Filter.name;
        }

        public int getId() {
            return 32004;
        }

        public Filter create(Map<String, Object> properties) {
            return new LZ4Filter(properties);
        }
    }
}

