/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteCharTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.seek(0L);
        this.fileHandle.writeChar(97);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChar(98);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChar(99);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)6L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChar(100);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((char)'a', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'b', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'c', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'d', (char)this.fileHandle.readChar());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        this.fileHandle.writeChar(101);
        this.fileHandle.writeChar(102);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((char)'e', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'f', (char)this.fileHandle.readChar());
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.seek(0L);
        this.fileHandle.writeChar(97);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChar(98);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((char)'a', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'b', (char)this.fileHandle.readChar());
        this.fileHandle.seek(0L);
        this.fileHandle.writeChar(99);
        this.fileHandle.writeChar(100);
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((char)'c', (char)this.fileHandle.readChar());
        AssertJUnit.assertEquals((char)'d', (char)this.fileHandle.readChar());
    }
}

