/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.AbstractStepInterpolator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.DummyStepHandler;
import org.apache.commons.math.ode.DummyStepInterpolator;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.StepHandler;
import org.apache.commons.math.ode.SwitchingFunction;
import org.apache.commons.math.ode.SwitchingFunctionsHandler;

public abstract class RungeKuttaIntegrator
implements FirstOrderIntegrator {
    private double[] c;
    private double[][] a;
    private double[] b;
    private RungeKuttaStepInterpolator prototype;
    private double step;
    private StepHandler handler;
    protected SwitchingFunctionsHandler switchesHandler;
    private double stepStart;
    private double stepSize;

    protected RungeKuttaIntegrator(double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double step) {
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.step = step;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    public abstract String getName();

    public void setStepHandler(StepHandler handler) {
        this.handler = handler;
    }

    public StepHandler getStepHandler() {
        return this.handler;
    }

    public void addSwitchingFunction(SwitchingFunction function, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.switchesHandler.add(function, maxCheckInterval, convergence, maxIterationCount);
    }

    private void sanityChecks(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2, double[] y) throws IntegratorException {
        if (equations.getDimension() != y0.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, initial state vector has dimension {1}", new Object[]{new Integer(equations.getDimension()), new Integer(y0.length)});
        }
        if (equations.getDimension() != y.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, final state vector has dimension {1}", new Object[]{new Integer(equations.getDimension()), new Integer(y.length)});
        }
        if (Math.abs(t2 - t0) <= 1.0E-12 * Math.max(Math.abs(t0), Math.abs(t2))) {
            throw new IntegratorException("too small integration interval: length = {0}", new Object[]{new Double(Math.abs(t2 - t0))});
        }
    }

    public void integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2, double[] y) throws DerivativeException, IntegratorException {
        AbstractStepInterpolator interpolator;
        this.sanityChecks(equations, t0, y0, t2, y);
        boolean forward = t2 > t0;
        int stages = this.c.length + 1;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[][] yDotK = new double[stages][];
        for (int i = 0; i < stages; ++i) {
            yDotK[i] = new double[y0.length];
        }
        double[] yTmp = new double[y0.length];
        if (this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty()) {
            RungeKuttaStepInterpolator rki = (RungeKuttaStepInterpolator)this.prototype.copy();
            rki.reinitialize(equations, yTmp, yDotK, forward);
            interpolator = rki;
        } else {
            interpolator = new DummyStepInterpolator(yTmp, forward);
        }
        interpolator.storeTime(t0);
        long nbStep = Math.max(1L, Math.abs(Math.round((t2 - t0) / this.step)));
        boolean lastStep = false;
        this.stepStart = t0;
        this.stepSize = (t2 - t0) / (double)nbStep;
        this.handler.reset();
        long i = 0L;
        while (!lastStep) {
            interpolator.shift();
            boolean needUpdate = false;
            boolean loop = true;
            while (loop) {
                equations.computeDerivatives(this.stepStart, y, yDotK[0]);
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y0.length; ++j) {
                        double sum = this.a[k - 1][0] * yDotK[0][j];
                        for (int l = 1; l < k; ++l) {
                            sum += this.a[k - 1][l] * yDotK[l][j];
                        }
                        yTmp[j] = y[j] + this.stepSize * sum;
                    }
                    equations.computeDerivatives(this.stepStart + this.c[k - 1] * this.stepSize, yTmp, yDotK[k]);
                }
                for (int j = 0; j < y0.length; ++j) {
                    double sum = this.b[0] * yDotK[0][j];
                    for (int l = 1; l < stages; ++l) {
                        sum += this.b[l] * yDotK[l][j];
                    }
                    yTmp[j] = y[j] + this.stepSize * sum;
                }
                interpolator.storeTime(this.stepStart + this.stepSize);
                if (this.switchesHandler.evaluateStep(interpolator)) {
                    needUpdate = true;
                    this.stepSize = this.switchesHandler.getEventTime() - this.stepStart;
                    continue;
                }
                loop = false;
            }
            double nextStep = this.stepStart + this.stepSize;
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            this.switchesHandler.stepAccepted(nextStep, y);
            lastStep = this.switchesHandler.stop() ? true : i == nbStep - 1L;
            interpolator.storeTime(nextStep);
            this.handler.handleStep(interpolator, lastStep);
            this.stepStart = nextStep;
            if (this.switchesHandler.reset(this.stepStart, y) && !lastStep) {
                equations.computeDerivatives(this.stepStart, y, yDotK[0]);
            }
            if (needUpdate) {
                nbStep = Math.max(1L, Math.abs(Math.round((t2 - this.stepStart) / this.step)));
                this.stepSize = (t2 - this.stepStart) / (double)nbStep;
                i = -1L;
            }
            ++i;
        }
        this.resetInternalState();
    }

    public double getCurrentStepStart() {
        return this.stepStart;
    }

    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    private void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }
}

