/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.UnsupportedCompressionException;

public class QTRLECodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        throw new UnsupportedCompressionException("QTRLE compression not supported.");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        byte[] b = new byte[(int)(in.length() - in.getFilePointer())];
        in.read(b);
        return this.decompress(b, options);
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws CodecException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        int numLines = options.height;
        if (data.length < 8) {
            return options.previousImage;
        }
        int bpp = options.bitsPerSample / 8;
        int line = options.width * bpp;
        try {
            ByteArrayHandle s2 = new ByteArrayHandle(data);
            s2.skipBytes(4);
            short header = s2.readShort();
            int off = 0;
            int start = 0;
            byte[] output = new byte[options.height * line];
            if ((header & 8) == 8) {
                int i;
                start = s2.readShort();
                s2.skipBytes(2);
                numLines = s2.readShort();
                s2.skipBytes(2);
                if (options.previousImage != null) {
                    for (i = 0; i < start; ++i) {
                        System.arraycopy(options.previousImage, off, output, off, line);
                        off += line;
                    }
                }
                if (options.previousImage != null) {
                    off = line * (start + numLines);
                    for (i = start + numLines; i < options.height; ++i) {
                        System.arraycopy(options.previousImage, off, output, off, line);
                        off += line;
                    }
                }
            } else {
                throw new CodecException("Unsupported header : " + header);
            }
            int skip = 0;
            byte rle = 0;
            int rowPointer = start * line;
            for (int i = 0; i < numLines; ++i) {
                block29: {
                    skip = s2.readUnsignedByte();
                    if (skip < 0) {
                        skip += 256;
                    }
                    if (options.previousImage != null) {
                        try {
                            System.arraycopy(options.previousImage, rowPointer, output, rowPointer, (skip - 1) * bpp);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                    off = rowPointer + (skip - 1) * bpp;
                    do {
                        if ((rle = (byte)(s2.readUnsignedByte() & 0xFF)) == 0) {
                            skip = s2.readUnsignedByte();
                            if (options.previousImage != null) {
                                try {
                                    System.arraycopy(options.previousImage, off, output, off, (skip - 1) * bpp);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                            off += (skip - 1) * bpp;
                            continue;
                        }
                        if (rle == -1) {
                            if (off < rowPointer + line && options.previousImage != null) {
                                System.arraycopy(options.previousImage, off, output, off, rowPointer + line - off);
                            }
                            break block29;
                        }
                        if (rle < -1) {
                            for (int j = 0; j < -1 * rle && off < output.length; off += bpp, ++j) {
                                System.arraycopy(data, (int)s2.getFilePointer(), output, off, bpp);
                            }
                            s2.skipBytes(bpp);
                            continue;
                        }
                        int len = rle * bpp;
                        if (output.length - off < len) {
                            len = output.length - off;
                        }
                        if (s2.length() - s2.getFilePointer() < (long)len) {
                            len = (int)(s2.length() - s2.getFilePointer());
                        }
                        if (len < 0) {
                            len = 0;
                        }
                        if (off > output.length) {
                            off = output.length;
                        }
                        s2.read(output, off, len);
                        off += len;
                    } while (s2.getFilePointer() < s2.length());
                    return output;
                }
                rowPointer += line;
            }
            return output;
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
    }
}

