/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.MFileIterator;
import ucar.nc2.util.CloseableIterator;

public class CollectionFiltered
extends CollectionAbstract {
    private MCollection org;
    private MFileFilter filter;

    public CollectionFiltered(String name, MCollection org, MFileFilter filter) {
        super(name, null);
        this.org = org;
        this.filter = filter;
        this.setRoot(org.getRoot());
    }

    @Override
    public void close() {
        this.org.close();
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        ArrayList<MFile> list = new ArrayList<MFile>(100);
        try (CloseableIterator<MFile> iter = this.getFileIterator();){
            while (iter.hasNext()) {
                list.add((MFile)iter.next());
            }
        }
        if (this.hasDateExtractor()) {
            list.sort(new CollectionAbstract.DateSorter(this));
        } else {
            Collections.sort(list);
        }
        return list;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MFileIterator(this.org.getFileIterator(), this.filter);
    }
}

