/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import javax.annotation.concurrent.Immutable;
import ucar.units.ConversionException;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.DerivedUnitImpl;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.Unit;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

@Immutable
public final class ScaledUnit
extends UnitImpl
implements DerivableUnit {
    private static final long serialVersionUID = 1L;
    private final double _scale;
    private final Unit _unit;

    public ScaledUnit(double scale) {
        this(scale, DerivedUnitImpl.DIMENSIONLESS);
    }

    public ScaledUnit(double scale, Unit unit) {
        this(scale, unit, null);
    }

    public ScaledUnit(double scale, Unit unit, UnitName id) {
        super(id);
        if (!(unit instanceof ScaledUnit)) {
            this._unit = unit;
            this._scale = scale;
        } else {
            this._unit = ((ScaledUnit)unit)._unit;
            this._scale = ((ScaledUnit)unit)._scale * scale;
        }
    }

    static Unit getInstance(double scale, Unit unit) throws MultiplyException {
        if (scale == 0.0) {
            throw new MultiplyException(scale, unit);
        }
        return scale == 1.0 ? unit : new ScaledUnit(scale, unit);
    }

    public double getScale() {
        return this._scale;
    }

    public Unit getUnit() {
        return this._unit;
    }

    @Override
    public Unit clone(UnitName id) {
        return new ScaledUnit(this._scale, this.getUnit(), id);
    }

    @Override
    public Unit multiplyBy(double scale) throws MultiplyException {
        return ScaledUnit.getInstance(scale * this._scale, this._unit);
    }

    @Override
    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        return that instanceof ScaledUnit ? new ScaledUnit(this.getScale() * ((ScaledUnit)that).getScale(), this.getUnit().multiplyBy(((ScaledUnit)that).getUnit())) : new ScaledUnit(this.getScale(), this.getUnit().multiplyBy(that));
    }

    @Override
    protected Unit myDivideBy(Unit that) throws OperationException {
        return that instanceof ScaledUnit ? new ScaledUnit(this.getScale() / ((ScaledUnit)that).getScale(), this.getUnit().divideBy(((ScaledUnit)that).getUnit())) : new ScaledUnit(this.getScale(), this.getUnit().divideBy(that));
    }

    @Override
    protected Unit myDivideInto(Unit that) throws OperationException {
        return that instanceof ScaledUnit ? new ScaledUnit(((ScaledUnit)that).getScale() / this.getScale(), this.getUnit().divideInto(((ScaledUnit)that).getUnit())) : new ScaledUnit(1.0 / this.getScale(), this.getUnit().divideInto(that));
    }

    @Override
    protected Unit myRaiseTo(int power) throws RaiseException {
        return new ScaledUnit(Math.pow(this.getScale(), power), this.getUnit().raiseTo(power));
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.getUnit().getDerivedUnit();
    }

    @Override
    public float toDerivedUnit(float amount) throws ConversionException {
        return (float)this.toDerivedUnit((double)amount);
    }

    @Override
    public double toDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        return ((DerivableUnit)((Object)this._unit)).toDerivedUnit(amount * this.getScale());
    }

    @Override
    public float[] toDerivedUnit(float[] input, float[] output) throws ConversionException {
        float scale = (float)this.getScale();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] * scale;
        }
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    @Override
    public double[] toDerivedUnit(double[] input, double[] output) throws ConversionException {
        double scale = this.getScale();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] * scale;
        }
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    @Override
    public float fromDerivedUnit(float amount) throws ConversionException {
        return (float)this.fromDerivedUnit((double)amount);
    }

    @Override
    public double fromDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        return ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(amount) / this.getScale();
    }

    @Override
    public float[] fromDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        float scale = (float)this.getScale();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] / scale;
        }
        return output;
    }

    @Override
    public double[] fromDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        double scale = this.getScale();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] / scale;
        }
        return output;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this._scale == 1.0) {
            return object.equals(this._unit);
        }
        if (!(object instanceof ScaledUnit)) {
            return false;
        }
        ScaledUnit that = (ScaledUnit)object;
        if (Double.compare(that._scale, this._scale) != 0) {
            return false;
        }
        return this._unit.equals(that._unit);
    }

    @Override
    public int hashCode() {
        return (this.getScale() == 1.0 ? 0 : Double.valueOf(this.getScale()).hashCode()) ^ this.getUnit().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return this.getUnit().isDimensionless();
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return DerivedUnitImpl.DIMENSIONLESS.equals(this._unit) ? Double.toString(this.getScale()) : this.getScale() + " " + this._unit.toString();
    }
}

