/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Binning implements Enumeration
{
    ONEBYONE("1x1"),
    TWOBYTWO("2x2"),
    FOURBYFOUR("4x4"),
    EIGHTBYEIGHT("8x8"),
    OTHER("Other");

    private final String value;

    private Binning(String value) {
        this.value = value;
    }

    public static Binning fromString(String value) throws EnumerationException {
        if ("1x1".equals(value)) {
            return ONEBYONE;
        }
        if ("2x2".equals(value)) {
            return TWOBYTWO;
        }
        if ("4x4".equals(value)) {
            return FOURBYFOUR;
        }
        if ("8x8".equals(value)) {
            return EIGHTBYEIGHT;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, Binning.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

