/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import jj2000.j2k.wavelet.synthesis.SynWTFilterInt;

public class SynWTFilterIntLift5x3
extends SynWTFilterInt {
    @Override
    public void synthetize_lpf(int[] lowSig, int lowOff, int lowLen, int lowStep, int[] highSig, int highOff, int highLen, int highStep, int[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff;
        outSig[ik] = outLen > 1 ? lowSig[lk] - (highSig[hk] + 1 >> 1) : lowSig[lk];
        lk += lowStep;
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = lowSig[lk] - (highSig[hk - highStep] + highSig[hk] + 2 >> 2);
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 2) {
            outSig[ik] = lowSig[lk] - (2 * highSig[hk - highStep] + 2 >> 2);
        }
        hk = highOff;
        ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1);
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 0 && outLen > 1) {
            outSig[ik] = highSig[hk] + outSig[ik - outStep];
        }
    }

    @Override
    public void synthetize_hpf(int[] lowSig, int lowOff, int lowLen, int lowStep, int[] highSig, int highOff, int highLen, int highStep, int[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = lowSig[lk] - (highSig[hk] + highSig[hk + highStep] + 2 >> 2);
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen > 1 && outLen % 2 == 0) {
            outSig[ik] = lowSig[lk] - (2 * highSig[hk] + 2 >> 2);
        }
        hk = highOff;
        ik = outOff;
        outSig[ik] = outLen > 1 ? highSig[hk] + outSig[ik + outStep] : highSig[hk] >> 1;
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1);
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 1) {
            outSig[ik] = highSig[hk] + outSig[ik - outStep];
        }
    }

    @Override
    public int getAnLowNegSupport() {
        return 2;
    }

    @Override
    public int getAnLowPosSupport() {
        return 2;
    }

    @Override
    public int getAnHighNegSupport() {
        return 1;
    }

    @Override
    public int getAnHighPosSupport() {
        return 1;
    }

    @Override
    public int getSynLowNegSupport() {
        return 1;
    }

    @Override
    public int getSynLowPosSupport() {
        return 1;
    }

    @Override
    public int getSynHighNegSupport() {
        return 2;
    }

    @Override
    public int getSynHighPosSupport() {
        return 2;
    }

    @Override
    public int getImplType() {
        return 0;
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public boolean isSameAsFullWT(int tailOvrlp, int headOvrlp, int inLen) {
        if (inLen % 2 == 0) {
            return tailOvrlp >= 2 && headOvrlp >= 1;
        }
        return tailOvrlp >= 2 && headOvrlp >= 2;
    }

    public String toString() {
        return "w5x3 (lifting)";
    }
}

