/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.GammaDistributionImpl;

public class ChiSquaredDistributionImpl
extends AbstractContinuousDistribution
implements ChiSquaredDistribution,
Serializable {
    private static final long serialVersionUID = -8352658048349159782L;
    private GammaDistribution gamma;

    public ChiSquaredDistributionImpl(double df) {
        this(df, new GammaDistributionImpl(df / 2.0, 2.0));
    }

    public ChiSquaredDistributionImpl(double df, GammaDistribution g2) {
        this.setGamma(g2);
        this.setDegreesOfFreedom(df);
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.getGamma().setAlpha(degreesOfFreedom / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.getGamma().getAlpha() * 2.0;
    }

    public double cumulativeProbability(double x) throws MathException {
        return this.getGamma().cumulativeProbability(x);
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        return Double.MIN_VALUE * this.getGamma().getBeta();
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getDegreesOfFreedom() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getDegreesOfFreedom() * 0.5 : this.getDegreesOfFreedom();
        return ret;
    }

    public void setGamma(GammaDistribution g2) {
        this.gamma = g2;
    }

    private GammaDistribution getGamma() {
        return this.gamma;
    }
}

