/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFTrajectoryProfileCollection
extends WriterCFPointAbstract {
    private static final String trajectoryIndexName = "trajectoryIndex";
    private int ntraj;
    private int traj_strlen;
    private Structure trajStructure;
    private HashMap<String, Integer> trajIndexMap;
    private HashSet<String> trajVarMap = new HashSet();
    private Structure profileStruct;
    private HashSet<String> profileVarMap = new HashSet();
    private int trajRecno;
    private int profileRecno;
    private int obsRecno;

    WriterCFTrajectoryProfileCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.trajectoryProfile.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Contiguous ragged array representation of trajectory profile, H.6.3"));
    }

    void setFeatureAuxInfo2(int ntraj, int traj_strlen) {
        this.ntraj = ntraj;
        this.traj_strlen = traj_strlen;
        this.trajIndexMap = new HashMap(2 * ntraj);
    }

    int writeProfile(TrajectoryProfileFeature section, ProfileFeature profile) throws IOException {
        int count = 0;
        if (this.id_strlen == 0) {
            this.id_strlen = profile.getName().length() * 2;
        }
        for (PointFeature pf : profile) {
            this.writeObsData(pf);
            ++count;
        }
        Integer sectionIndex = this.trajIndexMap.get(section.getName());
        if (sectionIndex == null) {
            sectionIndex = this.writeSectionData(section);
            this.trajIndexMap.put(section.getName(), sectionIndex);
        }
        this.writeProfileData(sectionIndex, profile, count);
        return count;
    }

    protected void writeHeader(List<TrajectoryProfileFeature> trajectoryProfiles) throws IOException {
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        ArrayList<ProfileFeature> profileFeatures = new ArrayList<ProfileFeature>();
        ArrayList<StructureData> trajectoryData = new ArrayList<StructureData>();
        ArrayList<StructureData> profileData = new ArrayList<StructureData>();
        for (TrajectoryProfileFeature trajectoryProfile : trajectoryProfiles) {
            trajectoryData.add(trajectoryProfile.getFeatureData());
            for (ProfileFeature profile : trajectoryProfile) {
                profileData.add(profile.getFeatureData());
                profileFeatures.add(profile);
            }
            obsCoords.add(VariableSimpleBuilder.makeScalar(trajectoryProfile.getTimeName(), "time of measurement", this.timeUnit.toString(), DataType.DOUBLE).build());
            Formatter coordNames = new Formatter().format("%s %s %s", trajectoryProfile.getTimeName(), "latitude", "longitude");
            if (this.altUnits == null) continue;
            this.altitudeCoordinateName = trajectoryProfile.getAltName();
            obsCoords.add(VariableSimpleBuilder.makeScalar(trajectoryProfile.getAltName(), "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
            coordNames.format(" %s", trajectoryProfile.getAltName());
        }
        super.writeHeader(obsCoords, profileFeatures, trajectoryData, profileData);
    }

    @Override
    void makeFeatureVariables(List<StructureData> featureData, boolean isExtended) {
        Dimension trajDim = this.writerb.addDimension("traj", this.ntraj);
        ArrayList<VariableSimpleIF> trajVars = new ArrayList<VariableSimpleIF>();
        trajVars.add(VariableSimpleBuilder.makeString("trajectoryId", "trajectory identifier", null, this.traj_strlen).addAttribute("cf_role", "trajectory_id").build());
        for (StructureData trajData : featureData) {
            for (StructureMembers.Member m4 : trajData.getMembers()) {
                if (this.findDataVar(m4.getName()) == null) continue;
                trajVars.add(VariableSimpleBuilder.fromMember(m4).build());
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("trajectory", "traj");
            this.addCoordinatesExtended(structb, trajVars);
        } else {
            this.addCoordinatesClassic(trajDim, trajVars, this.trajVarMap);
        }
    }

    @Override
    void makeMiddleVariables(List<StructureData> profileDataStructs, boolean isExtended) {
        Dimension profileDim = this.writerb.addDimension("profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").addAttribute("missing_value", String.valueOf(-9999)).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("latitude", "profile latitude", "degrees_north", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("longitude", "profile longitude", "degrees_east", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        profileVars.add(VariableSimpleBuilder.makeScalar(trajectoryIndexName, "trajectory index for this profile", null, DataType.INT).addAttribute("instance_dimension", "traj").build());
        for (StructureData profileData : profileDataStructs) {
            for (StructureMembers.Member m4 : profileData.getMembers()) {
                VariableSimpleIF dv = this.findDataVar(m4.getName());
                if (dv == null) continue;
                profileVars.add(dv);
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("profile", "profile");
            this.addCoordinatesExtended(structb, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.profileStruct = this.findStructure("profile");
        this.trajStructure = this.findStructure("trajectory");
    }

    private int writeSectionData(TrajectoryProfileFeature section) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberString("trajectoryId", null, null, section.getName().trim(), this.traj_strlen);
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, section.getFeatureData()));
        this.trajRecno = super.writeStructureData(this.trajRecno, this.trajStructure, sdall, this.trajVarMap);
        return this.trajRecno - 1;
    }

    private void writeProfileData(int sectionIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeOffsetFromRefDate(profile.getTime());
        smb.addMemberScalar("profileTime", null, null, DataType.DOUBLE, timeInMyUnits);
        smb.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        smb.addMemberScalar(trajectoryIndexName, null, null, DataType.INT, sectionIndex);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile.getFeatureData()));
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    private void writeObsData(PointFeature pf) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(pf.getFeatureCollection().getTimeName(), null, null, DataType.DOUBLE, pf.getObservationTime());
        if (this.altUnits != null) {
            smb.addMemberScalar(pf.getFeatureCollection().getAltName(), null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

