/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Medium implements Enumeration
{
    AIR("Air"),
    OIL("Oil"),
    WATER("Water"),
    GLYCEROL("Glycerol"),
    OTHER("Other");

    private final String value;

    private Medium(String value) {
        this.value = value;
    }

    public static Medium fromString(String value) throws EnumerationException {
        if ("Air".equals(value)) {
            return AIR;
        }
        if ("Oil".equals(value)) {
            return OIL;
        }
        if ("Water".equals(value)) {
            return WATER;
        }
        if ("Glycerol".equals(value)) {
            return GLYCEROL;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, Medium.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

