/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public enum NetcdfFileFormat {
    INVALID(0, "Invalid"),
    CLASSIC(1, "netcdf-3"),
    OFFSET_64BIT(2, "netcdf-3 64bit-offset"),
    NETCDF4(3, "netcdf-4"),
    NETCDF4_CLASSIC(4, "netcdf-4 classic"),
    DATA_64BIT(5, "netcdf-5"),
    HDF4(28677, "hdf-4");

    private static final int MAGIC_NUMBER_LEN = 8;
    private static final long MAXHEADERPOS = 50000L;
    private static final byte[] H5HEAD;
    private static final byte[] H4HEAD;
    private static final byte[] CDF1HEAD;
    private static final byte[] CDF2HEAD;
    private static final byte[] CDF5HEAD;
    private final int version;
    private final String formatName;

    private NetcdfFileFormat(int version, String formatName) {
        this.version = version;
        this.formatName = formatName;
    }

    public int version() {
        return this.version;
    }

    public String formatName() {
        return this.formatName;
    }

    public static NetcdfFileFormat findNetcdfFormatType(RandomAccessFile raf) throws IOException {
        byte[] magic = new byte[8];
        raf.seek(0L);
        if (raf.readBytes(magic, 0, 8) < 8) {
            return INVALID;
        }
        int hdrlen = CDF1HEAD.length;
        NetcdfFileFormat format = null;
        if (NetcdfFileFormat.memequal(CDF1HEAD, magic, CDF1HEAD.length)) {
            format = CLASSIC;
        } else if (NetcdfFileFormat.memequal(CDF2HEAD, magic, CDF2HEAD.length)) {
            format = OFFSET_64BIT;
        } else if (NetcdfFileFormat.memequal(CDF5HEAD, magic, CDF5HEAD.length)) {
            format = DATA_64BIT;
        } else if (NetcdfFileFormat.memequal(H4HEAD, magic, H4HEAD.length)) {
            format = HDF4;
        }
        if (format != null) {
            raf.seek(hdrlen);
            return format;
        }
        long filePos = 0L;
        long size = raf.length();
        while (filePos < size - 8L && filePos < 50000L) {
            raf.seek(filePos);
            if (raf.readBytes(magic, 0, 8) < 8) {
                return INVALID;
            }
            if (NetcdfFileFormat.memequal(H5HEAD, magic, H5HEAD.length)) {
                format = NETCDF4;
                break;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        if (format != null) {
            raf.seek(filePos + (long)H5HEAD.length);
        }
        return format == null ? INVALID : format;
    }

    public static boolean memequal(byte[] b1, byte[] b2, int len) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length < len || b2.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        H5HEAD = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
        H4HEAD = new byte[]{14, 3, 19, 1};
        CDF1HEAD = new byte[]{67, 68, 70, 1};
        CDF2HEAD = new byte[]{67, 68, 70, 2};
        CDF5HEAD = new byte[]{67, 68, 70, 5};
    }
}

