/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CommonInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import hdf.hdf5lib.structs.H5O_info_t;

public final class HDF5ObjectInformation
extends HDF5CommonInformation {
    private final long fileNumber;
    private final long address;
    private final int referenceCount;
    private final long creationTime;
    private final long numberOfAttributes;

    HDF5ObjectInformation(String path, HDF5ObjectType objectType, H5O_info_t info) {
        super(path, objectType);
        this.fileNumber = info.fileno;
        this.address = info.addr;
        this.referenceCount = info.rc;
        this.creationTime = info.ctime;
        this.numberOfAttributes = info.num_attrs;
    }

    public long getFileNumber() {
        return this.fileNumber;
    }

    public long getAddress() {
        return this.address;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (int)this.address;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5ObjectInformation other = (HDF5ObjectInformation)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return other.address == this.address;
    }
}

