/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader
extends SequentialReader {
    @NotNull
    private final InputStream _stream;
    private long _pos;

    @Override
    public long getPosition() {
        return this._pos;
    }

    public StreamReader(@NotNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        this._stream = stream;
        this._pos = 0L;
    }

    @Override
    public byte getByte() throws IOException {
        int value = this._stream.read();
        if (value == -1) {
            throw new EOFException("End of data reached.");
        }
        ++this._pos;
        return (byte)value;
    }

    @Override
    @NotNull
    public byte[] getBytes(int count) throws IOException {
        try {
            byte[] bytes = new byte[count];
            this.getBytes(bytes, 0, count);
            return bytes;
        }
        catch (OutOfMemoryError e) {
            throw new EOFException("End of data reached.");
        }
    }

    @Override
    public void getBytes(@NotNull byte[] buffer, int offset, int count) throws IOException {
        int totalBytesRead = 0;
        while (totalBytesRead != count) {
            int bytesRead = this._stream.read(buffer, offset + totalBytesRead, count - totalBytesRead);
            if (bytesRead == -1) {
                throw new EOFException("End of data reached.");
            }
            assert ((totalBytesRead += bytesRead) <= count);
        }
        this._pos += (long)totalBytesRead;
    }

    @Override
    public void skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        long skippedCount = this.skipInternal(n);
        if (skippedCount != n) {
            throw new EOFException(String.format("Unable to skip. Requested %d bytes but only %d remained.", n, skippedCount));
        }
    }

    @Override
    public boolean trySkip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        return this.skipInternal(n) == n;
    }

    @Override
    public int available() {
        try {
            return this._stream.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    private long skipInternal(long n) throws IOException {
        long skippedTotal;
        long skipped;
        for (skippedTotal = 0L; skippedTotal != n; skippedTotal += skipped) {
            skipped = this._stream.skip(n - skippedTotal);
            if (skipped != 0L) continue;
            break;
        }
        this._pos += skippedTotal;
        return skippedTotal;
    }
}

