/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;

public class FileConvert {
    private ImageReader reader;
    private ImageWriter writer;
    private String inputFile;
    private String outputFile;

    public FileConvert(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    public void convert() {
        boolean initializationSuccess = this.initialize();
        if (initializationSuccess) {
            this.convertPlanes();
        }
        this.cleanup();
    }

    private boolean initialize() {
        Throwable exception = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata omexml = service.createOMEXMLMetadata();
            this.reader = new ImageReader();
            this.reader.setMetadataStore((MetadataStore)omexml);
            this.reader.setId(this.inputFile);
            this.writer = new ImageWriter();
            this.writer.setMetadataRetrieve((MetadataRetrieve)omexml);
            this.writer.setInterleaved(this.reader.isInterleaved());
            this.writer.setId(this.outputFile);
        }
        catch (FormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        catch (DependencyException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        if (exception != null) {
            System.err.println("Failed to initialize files.");
            exception.printStackTrace();
        }
        return exception == null;
    }

    private void convertPlanes() {
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            try {
                this.writer.setSeries(series);
            }
            catch (FormatException e) {
                System.err.println("Failed to set writer's series #" + series);
                e.printStackTrace();
                break;
            }
            byte[] plane = new byte[FormatTools.getPlaneSize((IFormatReader)this.reader)];
            for (int image = 0; image < this.reader.getImageCount(); ++image) {
                try {
                    this.reader.openBytes(image, plane);
                    this.writer.saveBytes(image, plane);
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Failed to convert image #" + image + " in series #" + series);
                    e.printStackTrace();
                    continue;
                }
                catch (FormatException e) {
                    System.err.println("Failed to convert image #" + image + " in series #" + series);
                    e.printStackTrace();
                }
            }
        }
    }

    private void cleanup() {
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to cleanup reader and writer.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FileConvert converter = new FileConvert(args[0], args[1]);
        converter.convert();
    }
}

