/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadUnsignedByteTest {
    private static final byte[] PAGE = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, -1, -2};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadUnsignedByte() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)4, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)6, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)10, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)11, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)12, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)13, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)14, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)255, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)254, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testSeekForwardReadUnsignedByte() throws IOException {
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testResetReadUnsignedByte() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readUnsignedByte());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testSeekBackReadUnsignedByte() throws IOException {
        this.fileHandle.seek(15L);
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testRandomAccessReadUnsignedByte() throws IOException {
        this.testSeekForwardReadUnsignedByte();
        this.testSeekBackReadUnsignedByte();
        this.fileHandle.seek(0L);
        this.testResetReadUnsignedByte();
    }
}

