/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.utests;

import ome.xml.model.enums.Binning;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.handlers.BinningEnumHandler;
import ome.xml.model.enums.handlers.ImmersionEnumHandler;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class EnumHandlerTest {
    @Test
    public void testImmersionOI() throws EnumerationException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        Immersion v = (Immersion)handler.getEnumeration("OI");
        AssertJUnit.assertEquals((Object)Immersion.OIL, (Object)v);
    }

    @Test
    public void testImmersionOIWithWhitespace() throws EnumerationException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        Immersion v = (Immersion)handler.getEnumeration("   OI  ");
        AssertJUnit.assertEquals((Object)Immersion.OIL, (Object)v);
    }

    @Test
    public void testImmersionDRY() throws EnumerationException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        Immersion v = (Immersion)handler.getEnumeration("DRY");
        AssertJUnit.assertEquals((Object)Immersion.AIR, (Object)v);
    }

    @Test
    public void testImmersionDRYWithWhitespace() throws EnumerationException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        Immersion v = (Immersion)handler.getEnumeration("   DRY  ");
        AssertJUnit.assertEquals((Object)Immersion.AIR, (Object)v);
    }

    @Test
    public void testImmersionWl() throws EnumerationException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        Immersion v = (Immersion)handler.getEnumeration("Wl");
        AssertJUnit.assertEquals((Object)Immersion.WATER, (Object)v);
    }

    @Test
    public void testBinning1x1WithWhitespace() throws EnumerationException {
        BinningEnumHandler handler = new BinningEnumHandler();
        Binning v = (Binning)handler.getEnumeration("   1 x 1  ");
        AssertJUnit.assertEquals((Object)Binning.ONEBYONE, (Object)v);
    }

    @Test
    public void testBinning2x2WithWhitespace() throws EnumerationException {
        BinningEnumHandler handler = new BinningEnumHandler();
        Binning v = (Binning)handler.getEnumeration("   2 x 2  ");
        AssertJUnit.assertEquals((Object)Binning.TWOBYTWO, (Object)v);
    }

    @Test
    public void testBinning4x4WithWhitespace() throws EnumerationException {
        BinningEnumHandler handler = new BinningEnumHandler();
        Binning v = (Binning)handler.getEnumeration("   4 x 4  ");
        AssertJUnit.assertEquals((Object)Binning.FOURBYFOUR, (Object)v);
    }

    @Test
    public void testBinning8x8WithWhitespace() throws EnumerationException {
        BinningEnumHandler handler = new BinningEnumHandler();
        Binning v = (Binning)handler.getEnumeration("   8 x 8  ");
        AssertJUnit.assertEquals((Object)Binning.EIGHTBYEIGHT, (Object)v);
    }
}

