/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import java.lang.reflect.Constructor;
import loci.formats.FormatException;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import loci.formats.utests.tiff.BaseTiffMock;
import loci.formats.utests.tiff.BitsPerSampleSamplesPerPixelMismatchMock;
import loci.formats.utests.tiff.NonUniformRowsPerStripMock;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"tiffParserTests"})
public class TiffParserTest {
    private TiffParser tiffParser;
    private BaseTiffMock mock;

    @Parameters(value={"mockClassName"})
    @BeforeMethod
    public void setUp(String mockClassName) throws Exception {
        Class<?> mockClass = Class.forName(mockClassName);
        Constructor<?> constructor = mockClass.getDeclaredConstructor(new Class[0]);
        this.mock = (BaseTiffMock)constructor.newInstance(new Object[0]);
        this.tiffParser = this.mock.getTiffParser();
    }

    @Test
    public void testHeader() throws IOException {
        AssertJUnit.assertTrue((boolean)this.tiffParser.isValidHeader());
        AssertJUnit.assertTrue((boolean)this.tiffParser.checkHeader());
        AssertJUnit.assertFalse((boolean)this.tiffParser.isBigTiff());
    }

    @Test
    public void testFirstOffset() throws IOException {
        AssertJUnit.assertEquals((long)8L, (long)this.tiffParser.getFirstOffset());
    }

    @Test
    public void testGetPhotoInterp() throws IOException, FormatException {
        AssertJUnit.assertEquals((Object)PhotoInterp.RGB, (Object)this.tiffParser.getFirstIFD().getPhotometricInterpretation());
    }

    @Test
    public void testGetImageLength() throws IOException, FormatException {
        AssertJUnit.assertEquals((long)this.mock.getImageLength(), (long)this.tiffParser.getFirstIFD().getImageLength());
    }

    @Test
    public void testGetImageWidth() throws IOException, FormatException {
        AssertJUnit.assertEquals((long)this.mock.getImageWidth(), (long)this.tiffParser.getFirstIFD().getImageWidth());
    }

    @Test
    public void testGetBitsPerSample() throws IOException, FormatException {
        int[] bitsPerSample = this.tiffParser.getFirstIFD().getBitsPerSample();
        AssertJUnit.assertNotNull((Object)bitsPerSample);
        AssertJUnit.assertEquals((int)this.mock.getSamplesPerPixel(), (int)bitsPerSample.length);
        int[] BITS_PER_SAMPLE = this.mock.getBitsPerSample();
        for (int i = 0; i < BITS_PER_SAMPLE.length; ++i) {
            int a = BITS_PER_SAMPLE[i];
            long b = bitsPerSample[i];
            if ((long)a == b) continue;
            AssertJUnit.fail((String)String.format("Bits per sample offset %d not equivilent: %d != %d", i, a, b));
        }
    }

    @Test
    public void testGetSamplesPerPixel() throws IOException, FormatException {
        AssertJUnit.assertEquals((int)this.mock.getSamplesPerPixel(), (int)this.tiffParser.getFirstIFD().getSamplesPerPixel());
    }

    @Test
    public void testGetStripOffsets() throws IOException, FormatException {
        long[] stripOffsets = this.tiffParser.getFirstIFD().getStripOffsets();
        AssertJUnit.assertNotNull((Object)stripOffsets);
        int[] STRIP_OFFSETS = this.mock.getStripOffsets();
        AssertJUnit.assertEquals((int)STRIP_OFFSETS.length, (int)stripOffsets.length);
        for (int i = 0; i < STRIP_OFFSETS.length; ++i) {
            int a = STRIP_OFFSETS[i];
            long b = stripOffsets[i];
            if ((long)a == b) continue;
            AssertJUnit.fail((String)String.format("Strip offset %d not equivilent: %d != %d", i, a, b));
        }
    }

    @Test
    public void testGetRowsPerStrip() throws IOException, FormatException {
        long[] rowsPerStrip = this.tiffParser.getFirstIFD().getRowsPerStrip();
        AssertJUnit.assertNotNull((Object)rowsPerStrip);
        int[] ROWS_PER_STRIP = this.mock.getRowsPerStrip();
        AssertJUnit.assertEquals((int)ROWS_PER_STRIP.length, (int)rowsPerStrip.length);
        for (int i = 0; i < ROWS_PER_STRIP.length; ++i) {
            int a = ROWS_PER_STRIP[i];
            long b = rowsPerStrip[i];
            if ((long)a == b) continue;
            AssertJUnit.fail((String)String.format("Rows per strip %d not equivilent: %d != %d", i, a, b));
        }
    }

    @Test
    public void testGetXResolution() throws IOException, FormatException {
        int tag = 282;
        AssertJUnit.assertTrue((boolean)this.mock.getXResolution().equals((Object)this.tiffParser.getFirstIFD().getIFDRationalValue(tag)));
    }

    @Test
    public void testGetYResolution() throws IOException, FormatException {
        int tag = 283;
        AssertJUnit.assertTrue((boolean)this.mock.getYResolution().equals((Object)this.tiffParser.getFirstIFD().getIFDRationalValue(tag)));
    }

    @Test
    public void testGetResolutionUnit() throws IOException, FormatException {
        int tag = 296;
        AssertJUnit.assertEquals((int)this.mock.getResolutionUnit(), (int)this.tiffParser.getFirstIFD().getIFDIntValue(tag));
    }

    @Test(expectedExceptions={FormatException.class})
    public void testNonUniformRowsPerStrip() throws IOException, FormatException {
        this.mock = new NonUniformRowsPerStripMock();
        this.tiffParser = this.mock.getTiffParser();
        AssertJUnit.assertTrue((boolean)this.tiffParser.checkHeader());
        this.tiffParser.getFirstIFD().getRowsPerStrip();
        this.mock.close();
    }

    @Test
    public void testBitsPerSampleMismatch() throws IOException, FormatException {
        this.mock = new BitsPerSampleSamplesPerPixelMismatchMock();
        this.tiffParser = this.mock.getTiffParser();
        AssertJUnit.assertTrue((boolean)this.tiffParser.checkHeader());
        IFD ifd = this.tiffParser.getFirstIFD();
        int[] bitsPerSample = ifd.getBitsPerSample();
        int[] mockBitsPerSample = this.mock.getBitsPerSample();
        AssertJUnit.assertEquals((int)bitsPerSample.length, (int)ifd.getSamplesPerPixel());
        for (int i = 0; i < mockBitsPerSample.length; ++i) {
            AssertJUnit.assertEquals((int)bitsPerSample[i], (int)mockBitsPerSample[i]);
        }
        this.mock.close();
    }
}

