/*
 * Decompiled with CFR 0.152.
 */
package com.drew.tools;

import com.drew.lang.annotations.NotNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtil {
    public static void saveBytes(@NotNull File file2, @NotNull byte[] bytes) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file2);
            stream.write(bytes);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] readBytes(@NotNull File file2) throws IOException {
        int length = (int)file2.length();
        assert (length != 0);
        byte[] bytes = new byte[length];
        FileInputStream inputStream = null;
        try {
            int bytesRead;
            inputStream = new FileInputStream(file2);
            for (int totalBytesRead = 0; totalBytesRead != length; totalBytesRead += bytesRead) {
                bytesRead = inputStream.read(bytes, totalBytesRead, length - totalBytesRead);
                if (bytesRead != -1) continue;
                break;
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return bytes;
    }

    @NotNull
    public static byte[] readBytes(@NotNull String filePath) throws IOException {
        return FileUtil.readBytes(new File(filePath));
    }
}

