/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.util.Locale;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DataToolsTest {
    @DataProvider(name="locales")
    public Object[][] createData() {
        return new Object[][]{{"FR"}, {"DE"}, {"US"}, {"GB"}};
    }

    @Test
    public void testSafeMultiply32() {
        boolean ok = false;
        try {
            DataTools.safeMultiply32(null);
        }
        catch (NullPointerException e) {
            ok = true;
        }
        if (!ok) {
            AssertJUnit.fail((String)"Expected NullPointerException");
        }
        this.assertSafeMultiply32Pass(0, new int[0]);
        this.assertSafeMultiply32Pass(1, 1);
        this.assertSafeMultiply32Pass(54, 9, 6);
        this.assertSafeMultiply32Pass(1037836800, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
        this.assertSafeMultiply32Fail("Invalid array size: -1", -1);
        this.assertSafeMultiply32Fail("Invalid array size: 0", 0);
        this.assertSafeMultiply32Pass(0x7FFFFFFE, 0x3FFFFFFF, 2);
        this.assertSafeMultiply32Fail("Array size too large: 1073741824 x 2", 0x40000000, 2);
        this.assertSafeMultiply32Pass(2147441940, 46340, 46341);
        this.assertSafeMultiply32Fail("Array size too large: 46341 x 46341", 46341, 46341);
        this.assertSafeMultiply32Fail("Array size too large: 46340 x 46342", 46340, 46342);
        this.assertSafeMultiply32Pass(0x7FFF0000, 65536, Short.MAX_VALUE);
        this.assertSafeMultiply32Pass(2147450880, 65535, 32768);
        this.assertSafeMultiply32Fail("Array size too large: 65536 x 32768", 65536, 32768);
    }

    @Test
    public void testSafeMultiply64() {
        boolean ok = false;
        try {
            DataTools.safeMultiply64(null);
        }
        catch (NullPointerException e) {
            ok = true;
        }
        if (!ok) {
            AssertJUnit.fail((String)"Expected NullPointerException");
        }
        this.assertSafeMultiply64Pass(0L, new long[0]);
        this.assertSafeMultiply64Pass(1L, 1L);
        this.assertSafeMultiply64Pass(54L, 9L, 6L);
        this.assertSafeMultiply64Pass(3632428800L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L);
        this.assertSafeMultiply64Fail("Invalid array size: -1", -1L);
        this.assertSafeMultiply64Fail("Invalid array size: 0", 0L);
        this.assertSafeMultiply64Pass(0x7FFFFFFFFFFFFFFEL, 0x1555555555555555L, 2L, 3L);
        this.assertSafeMultiply64Fail("Array size too large: 1537228672809129302 x 2 x 3", 0x1555555555555556L, 2L, 3L);
        this.assertSafeMultiply64Pass(9223372033963249500L, 3037000499L, 3037000500L);
        this.assertSafeMultiply64Fail("Array size too large: 3037000500 x 3037000500", 3037000500L, 3037000500L);
        this.assertSafeMultiply64Fail("Array size too large: 3037000499 x 3037000501", 3037000499L, 3037000501L);
    }

    private void assertSafeMultiply32Pass(int expected, int ... sizes) {
        AssertJUnit.assertEquals((int)expected, (int)DataTools.safeMultiply32((int[])sizes));
    }

    private void assertSafeMultiply32Fail(String msg, int ... sizes) {
        int actual;
        try {
            actual = DataTools.safeMultiply32((int[])sizes);
        }
        catch (IllegalArgumentException e) {
            AssertJUnit.assertEquals((String)e.getMessage(), (String)msg);
            return;
        }
        AssertJUnit.fail((String)("Safe multiply succeeded with value: " + actual));
    }

    private void assertSafeMultiply64Pass(long expected, long ... sizes) {
        AssertJUnit.assertEquals((long)expected, (long)DataTools.safeMultiply64((long[])sizes));
    }

    private void assertSafeMultiply64Fail(String msg, long ... sizes) {
        long actual;
        try {
            actual = DataTools.safeMultiply64((long[])sizes);
        }
        catch (IllegalArgumentException e) {
            AssertJUnit.assertEquals((String)e.getMessage(), (String)msg);
            return;
        }
        AssertJUnit.fail((String)("Safe multiply succeeded with value: " + actual));
    }

    @Test
    public void testParseByte() {
        AssertJUnit.assertEquals((Object)DataTools.parseByte(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"0"), (Object)new Byte(0));
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"1"), (Object)new Byte(1));
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"1.0"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"0.1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"0,1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseByte((String)"not a number"), null);
    }

    @Test
    public void testParseShort() {
        AssertJUnit.assertEquals((Object)DataTools.parseShort(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"0"), (Object)new Short(0));
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"1"), (Object)new Short(1));
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"1.0"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"0.1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"0,1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseShort((String)"not a number"), null);
    }

    @Test
    public void testParseInteger() {
        AssertJUnit.assertEquals((Object)DataTools.parseInteger(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"0"), (Object)0);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"1"), (Object)1);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"1.0"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"0.1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"0,1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseInteger((String)"not a number"), null);
    }

    @Test
    public void testParseLong() {
        AssertJUnit.assertEquals((Object)DataTools.parseLong(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"0"), (Object)0L);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"1"), (Object)1L);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"1.0"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"0.1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"0,1"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseLong((String)"not a number"), null);
    }

    @Test(dataProvider="locales")
    public void testParseFloat(String locale) {
        Locale.setDefault(new Locale(locale));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"0"), (Object)Float.valueOf(0.0f));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"1"), (Object)Float.valueOf(1.0f));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"1.0"), (Object)Float.valueOf(1.0f));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"0.1"), (Object)Float.valueOf(0.1f));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"0,1"), (Object)Float.valueOf(0.1f));
        AssertJUnit.assertEquals((Object)DataTools.parseFloat((String)"not a number"), null);
    }

    @Test(dataProvider="locales")
    public void testParseDouble(String locale) {
        Locale.setDefault(new Locale(locale));
        AssertJUnit.assertEquals((Object)DataTools.parseDouble(null), null);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)""), null);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"0"), (Object)0.0);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"1"), (Object)1.0);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"1.0"), (Object)1.0);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"0.1"), (Object)0.1);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"0,1"), (Object)0.1);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"not a number"), null);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"2.5E-005"), (Object)2.5E-5);
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"1.5e-005"), (Object)1.5E-5);
    }

    @Test(threadPoolSize=10, invocationCount=1000)
    public void testThreadSafety() {
        AssertJUnit.assertEquals((Object)DataTools.parseDouble((String)"1.0"), (Object)1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileDefaultEncoding() {
        String src = "\u00b5\u20ac\u0153\u1e9e";
        String tmpFile = "utf-test.txt";
        try {
            byte[] bytes = src.getBytes("UTF-8");
            Location.mapFile((String)tmpFile, (IRandomAccess)new ByteArrayHandle(bytes));
            String result = DataTools.readFile((String)tmpFile);
            AssertJUnit.assertEquals((String)src, (String)result);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.getMessage());
        }
        finally {
            Location.mapFile((String)tmpFile, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileDifferentEncoding() {
        String src = "\u00b5\u20ac\u0153";
        String tmpFile = "windows-1252-test.txt";
        try {
            byte[] bytes = src.getBytes("windows-1252");
            Location.mapFile((String)tmpFile, (IRandomAccess)new ByteArrayHandle(bytes));
            String result = DataTools.readFile((String)tmpFile, (String)"windows-1252");
            AssertJUnit.assertEquals((String)src, (String)result);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.getMessage());
        }
        finally {
            Location.mapFile((String)tmpFile, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileWrongEncoding() {
        String src = "\u00b5\u20ac\u0153";
        String tmpFile = "windows-1252-vs-utf8-test.txt";
        try {
            byte[] bytes = src.getBytes("UTF-8");
            Location.mapFile((String)tmpFile, (IRandomAccess)new ByteArrayHandle(bytes));
            String result = DataTools.readFile((String)tmpFile, (String)"windows-1252");
            AssertJUnit.assertFalse((boolean)src.equals(result));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.getMessage());
        }
        finally {
            Location.mapFile((String)tmpFile, null);
        }
    }
}

