/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class SkipBytesTest {
    private static final byte[] PAGE = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 2;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 2);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)64L, (long)this.fileHandle.length());
    }

    @Test
    public void testSkip4Bytes() throws IOException {
        int skipLength = this.fileHandle.skipBytes(4);
        AssertJUnit.assertEquals((int)4, (int)skipLength);
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)6, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSkipOffEnd() throws IOException {
        int skipLength = this.fileHandle.skipBytes(65);
        AssertJUnit.assertEquals((int)64, (int)skipLength);
    }

    @Test
    public void testSkipNegativeBytes() throws IOException {
        AssertJUnit.assertEquals((int)0, (int)this.fileHandle.skipBytes(-1));
    }

    @Test
    public void testSkipZeroBytes() throws IOException {
        AssertJUnit.assertEquals((int)0, (int)this.fileHandle.skipBytes(0));
    }
}

