/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.HandleException;
import loci.common.URLHandle;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class URLHandleTest {
    private URLHandle fileHandle;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final int EMPTY_BUFFER_SIZE = 0x100000;

    @BeforeMethod
    public void setup() throws IOException {
        File tmpFile = File.createTempFile("urlhandle", "tmp");
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        out.write("hello, world!\n".getBytes("UTF-8"));
        byte[] emptyBuffer = new byte[0x100000];
        out.write(emptyBuffer);
        out.write("goodbye, world!\n".getBytes("UTF-8"));
        out.close();
        String path = tmpFile.getAbsolutePath();
        this.fileHandle = new URLHandle((IS_WINDOWS ? "file:/" : "file://") + path);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)0x10001EL, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadByte() throws IOException {
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)104, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)101, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)108, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)108, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)111, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)44, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)32, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)119, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)111, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)114, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)108, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)100, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)10, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSequentialReadShort() throws IOException {
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)26725, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)27756, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)28460, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)8311, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)28530, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)27748, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)8458, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSequentialReadInt() throws IOException {
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1751477356, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)1865162871, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)1869769828, (int)this.fileHandle.readInt());
    }

    @Test
    public void testSequentialReadLong() throws IOException {
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((long)7522537965569712247L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testSeekForwardReadByte() throws IOException {
        this.fileHandle.seek(5L);
        AssertJUnit.assertEquals((int)44, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSeekForwardReadShort() throws IOException {
        this.fileHandle.seek(5L);
        AssertJUnit.assertEquals((int)11296, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekForwardReadInt() throws IOException {
        this.fileHandle.seek(5L);
        AssertJUnit.assertEquals((int)740325231, (int)this.fileHandle.readInt());
    }

    @Test
    public void testSeekForwardReadLong() throws IOException {
        this.fileHandle.seek(5L);
        AssertJUnit.assertEquals((long)3179672657468351521L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testSeekBackReadByte() throws IOException {
        this.fileHandle.seek(13L);
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)119, (int)this.fileHandle.readByte());
        this.fileHandle.seek(0x100017L);
        AssertJUnit.assertEquals((int)119, (int)this.fileHandle.readByte());
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)119, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSeekBackReadShort() throws IOException {
        this.fileHandle.seek(13L);
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)30575, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekBackReadInt() throws IOException {
        this.fileHandle.seek(13L);
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)2003792492, (int)this.fileHandle.readInt());
    }

    @Test
    public void testSeekBackReadLong() throws IOException {
        this.fileHandle.seek(13L);
        this.fileHandle.seek(5L);
        AssertJUnit.assertEquals((long)3179672657468351521L, (long)this.fileHandle.readLong());
    }

    @Test(expectedExceptions={EOFException.class})
    public void testEOF() throws IOException {
        this.fileHandle.seek(0x10001EL);
        this.fileHandle.readByte();
    }

    @Test(expectedExceptions={HandleException.class})
    public void testWrite() throws IOException {
        this.fileHandle.write(0);
    }
}

