/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.util.Misc;

@Immutable
public class LatLonPointNoNormalize {
    private final double lat;
    private final double lon;

    public LatLonPointNoNormalize(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lon;
    }

    public boolean nearlyEquals(LatLonPointNoNormalize that) {
        return this.nearlyEquals(that, 1.0E-8);
    }

    public boolean nearlyEquals(LatLonPointNoNormalize that, double maxRelDiff) {
        return Misc.nearlyEquals(this.getLatitude(), that.getLatitude(), maxRelDiff) && Misc.nearlyEquals(this.getLongitude(), that.getLongitude(), maxRelDiff);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLonPointNoNormalize that = (LatLonPointNoNormalize)o;
        return Double.compare(this.getLatitude(), that.getLatitude()) == 0 && Double.compare(this.getLongitude(), that.getLongitude()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon);
    }

    public String toString() {
        return String.format("(%.4f, %.4f)", this.lat, this.lon);
    }
}

