/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.formats.utests.SPWModelMock;
import ome.xml.model.Image;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.MapPair;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Pixels;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImagingEnvironmentMapTest {
    private OME ome = new OME();

    @BeforeClass
    public void setUp() throws Exception {
        Image image = new Image();
        image.setID("Image:0");
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:0");
        image.setPixels(pixels);
        ImagingEnvironment imagingEnvironment = new ImagingEnvironment();
        ArrayList<MapPair> map = new ArrayList<MapPair>();
        map.add(new MapPair("a", "1"));
        map.add(new MapPair("d", "2"));
        map.add(new MapPair("c", "3"));
        map.add(new MapPair("b", "4"));
        map.add(new MapPair("e", "5"));
        map.add(new MapPair("c", "6"));
        AssertJUnit.assertEquals((int)6, (int)map.size());
        imagingEnvironment.setMap(map);
        image.setImagingEnvironment(imagingEnvironment);
        this.ome.addImage(image);
    }

    @Test
    public void testGenericExcitationSourceValid() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
    }

    @Test
    public void testGenericExcitationSourceMapContent() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
        AssertJUnit.assertNotNull((Object)this.ome);
        AssertJUnit.assertEquals((String)this.ome.getImage(0).getPixels().getID(), (String)"Pixels:0");
        AssertJUnit.assertNotNull((Object)this.ome.getImage(0).getImagingEnvironment());
        ImagingEnvironment imagingEnvironment = this.ome.getImage(0).getImagingEnvironment();
        List dataMap = imagingEnvironment.getMap();
        AssertJUnit.assertEquals((int)6, (int)dataMap.size());
        this.assertPair(dataMap, 0, "a", "1");
        this.assertPair(dataMap, 1, "d", "2");
        this.assertPair(dataMap, 2, "c", "3");
        this.assertPair(dataMap, 3, "b", "4");
        this.assertPair(dataMap, 4, "e", "5");
        this.assertPair(dataMap, 5, "c", "6");
    }

    void assertPair(List<MapPair> dataMap, int idx, String name, String value) {
        AssertJUnit.assertEquals((String)name, (String)dataMap.get(idx).getName());
        AssertJUnit.assertEquals((String)value, (String)dataMap.get(idx).getValue());
    }
}

