/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.utests.InOutCurrentTest;
import loci.formats.utests.OMEModelMock;
import ome.units.UNITS;
import ome.units.quantity.Power;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class IMetadataBasedOMEModelMock
implements OMEModelMock {
    private OMEXMLMetadataImpl store = new OMEXMLMetadataImpl();

    public IMetadataBasedOMEModelMock() {
        this.store.createRoot();
        this.makeImage();
        this.makeInstrument();
        this.makePlate();
        this.makeROI();
        this.store.resolveReferences();
    }

    @Override
    public MetadataRoot getRoot() {
        return this.store.getRoot();
    }

    private void makeImage() {
        this.store.setImageID("Image:0", 0);
        this.store.setListAnnotationID("Annotation:ImageList0", 0);
        this.store.setListAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setBooleanAnnotationID("Annotation:ImageBoolean0", 0);
        this.store.setBooleanAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setListAnnotationAnnotationRef("Annotation:ImageBoolean0", 0, 0);
        this.store.setBooleanAnnotationValue(InOutCurrentTest.IMAGE_ANNOTATION_VALUE, 0);
        this.store.setBooleanAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setBooleanAnnotationValue(InOutCurrentTest.IMAGE_ANNOTATION_VALUE, 0);
        this.store.setImageAnnotationRef("Annotation:ImageList0", 0, 0);
        this.store.setPixelsID("Pixels:0", 0);
        this.store.setPixelsSizeX(new PositiveInteger(InOutCurrentTest.SIZE_X), 0);
        this.store.setPixelsSizeY(new PositiveInteger(InOutCurrentTest.SIZE_Y), 0);
        this.store.setPixelsSizeZ(new PositiveInteger(InOutCurrentTest.SIZE_Z), 0);
        this.store.setPixelsSizeC(new PositiveInteger(InOutCurrentTest.SIZE_C), 0);
        this.store.setPixelsSizeT(new PositiveInteger(InOutCurrentTest.SIZE_T), 0);
        this.store.setPixelsDimensionOrder(InOutCurrentTest.DIMENSION_ORDER, 0);
        this.store.setPixelsType(InOutCurrentTest.PIXEL_TYPE, 0);
        this.store.setUUIDValue("6DFA2954-FA9B-4447-A26C-82F9580D9425", 0, 0);
        this.store.setXMLAnnotationID("Annotation:ChannelXML0", 0);
        this.store.setXMLAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setXMLAnnotationValue("<TestData><key>foo</key><value>bar</value></TestData>", 0);
        this.store.setXMLAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        for (int i = 0; i < InOutCurrentTest.SIZE_C; ++i) {
            this.store.setChannelID("Channel:" + i, 0, i);
            if (i != 0) continue;
            this.store.setChannelAnnotationRef("Annotation:ChannelXML0", 0, i, 0);
        }
    }

    private void makeInstrument() {
        this.store.setInstrumentID("Instrument:0", 0);
        this.store.setDetectorID("Detector:0", 0, 0);
        this.store.setDetectorModel("ReallySensitive!", 0, 0);
        this.store.setCommentAnnotationID("Annotation:DetectorString2", 0);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setCommentAnnotationValue("Value:String2", 0);
        this.store.setDetectorAnnotationRef("Annotation:DetectorString2", 0, 0, 0);
        this.store.setLaserID("LightSource:0", 0, 0);
        this.store.setLaserModel("ReallyBrightLaser!", 0, 0);
        this.store.setLaserType(InOutCurrentTest.LASER_TYPE, 0, 0);
        this.store.setLaserPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_LASER_POWER, UNITS.MILLIWATT), 0, 0);
        this.store.setCommentAnnotationID("Annotation:LightSourceLaserString3", 1);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 1);
        this.store.setCommentAnnotationValue("Value:String3", 1);
        this.store.setLaserAnnotationRef("Annotation:LightSourceLaserString3", 0, 0, 0);
        this.store.setLaserID("LightSource:1", 0, 1);
        this.store.setLaserModel("ReallyBrightPump!", 0, 1);
        this.store.setLaserType(InOutCurrentTest.LASER_TYPE, 0, 1);
        this.store.setLaserPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_PUMP_POWER, UNITS.MILLIWATT), 0, 1);
        this.store.setLaserPump("LightSource:1", 0, 0);
        this.store.setArcID("LightSource:2", 0, 2);
        this.store.setArcModel("ReallyBrightArc!", 0, 2);
        this.store.setArcType(InOutCurrentTest.ARC_TYPE, 0, 2);
        this.store.setArcPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_ARC_POWER, UNITS.MILLIWATT), 0, 2);
        this.store.setCommentAnnotationID("Annotation:LightSourceArcString4", 2);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 2);
        this.store.setCommentAnnotationValue("Value:String4", 2);
        this.store.setArcAnnotationRef("Annotation:LightSourceArcString4", 0, 2, 0);
        this.store.setFilamentID("LightSource:3", 0, 3);
        this.store.setFilamentModel("ReallyBrightFilament!", 0, 3);
        this.store.setFilamentType(InOutCurrentTest.FILAMENT_TYPE, 0, 3);
        this.store.setFilamentPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_FILAMENT_POWER, UNITS.MILLIWATT), 0, 3);
        this.store.setCommentAnnotationID("Annotation:LightSourceFilamentString5", 3);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 3);
        this.store.setCommentAnnotationValue("Value:String5", 3);
        this.store.setFilamentAnnotationRef("Annotation:LightSourceFilamentString5", 0, 3, 0);
        this.store.setLightEmittingDiodeID("LightSource:4", 0, 4);
        this.store.setLightEmittingDiodeModel("ReallyBrightLED!", 0, 4);
        this.store.setLightEmittingDiodePower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_LED_POWER, UNITS.MILLIWATT), 0, 4);
        this.store.setCommentAnnotationID("Annotation:LightSourceLEDString6", 4);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 4);
        this.store.setCommentAnnotationValue("Value:String6", 4);
        this.store.setLightEmittingDiodeAnnotationRef("Annotation:LightSourceLEDString6", 0, 4, 0);
        this.store.setDichroicID("Dichroic:0", 0, 0);
        this.store.setDichroicSerialNumber("0123456789", 0, 0);
        this.store.setCommentAnnotationID("Annotation:DichroicString7", 5);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 5);
        this.store.setCommentAnnotationValue("Value:String7", 5);
        this.store.setDichroicAnnotationRef("Annotation:DichroicString7", 0, 0, 0);
        this.store.setFilterSetID("FilterSet:0", 0, 0);
        this.store.setFilterSetLotNumber("RandomLot", 0, 0);
        this.store.setFilterSetDichroicRef("Dichroic:0", 0, 0);
        this.store.setFilterSetEmissionFilterRef("Filter:0", 0, 0, 0);
        this.store.setFilterSetExcitationFilterRef("Filter:1", 0, 0, 0);
        this.store.setFilterID("Filter:0", 0, 0);
        this.store.setFilterType(InOutCurrentTest.EM_FILTER_TYPE, 0, 0);
        this.store.setCommentAnnotationID("Annotation:EmFilterString8", 6);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 6);
        this.store.setCommentAnnotationValue("Value:String8", 6);
        this.store.setFilterAnnotationRef("Annotation:EmFilterString8", 0, 0, 0);
        this.store.setFilterID("Filter:1", 0, 1);
        this.store.setFilterType(InOutCurrentTest.EX_FILTER_TYPE, 0, 1);
        this.store.setObjectiveID("Objective:0", 0, 0);
        this.store.setObjectiveModel("ReallyClear!", 0, 0);
        this.store.setCommentAnnotationID("Annotation:ObjectiveString9", 7);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 7);
        this.store.setCommentAnnotationValue("Value:String9", 7);
        this.store.setObjectiveAnnotationRef("Annotation:ObjectiveString9", 0, 0, 0);
        this.store.setCommentAnnotationID("Annotation:InstrumentString1", 8);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 8);
        this.store.setCommentAnnotationValue("Value:String1", 8);
        this.store.setInstrumentAnnotationRef("Annotation:InstrumentString1", 0, 0);
        this.store.setImageInstrumentRef("Instrument:0", 0);
    }

    private void makePlate() {
        this.store.setPlateID("Plate:0", 0);
        this.store.setPlateRows(InOutCurrentTest.WELL_ROWS, 0);
        this.store.setPlateColumns(InOutCurrentTest.WELL_COLS, 0);
        this.store.setPlateRowNamingConvention(InOutCurrentTest.WELL_ROW, 0);
        this.store.setPlateColumnNamingConvention(InOutCurrentTest.WELL_COL, 0);
        this.store.setPlateAnnotationRef("Annotation:PlateTimestamp0", 0, 0);
        this.store.setTimestampAnnotationID("Annotation:PlateTimestamp0", 0);
        this.store.setTimestampAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
        this.store.setTimestampAnnotationValue(new Timestamp("1970-01-01T00:00:00"), 0);
        int wellSampleIndex = 0;
        int wellCount = 0;
        for (int row = 0; row < (Integer)InOutCurrentTest.WELL_ROWS.getValue(); ++row) {
            for (int col = 0; col < (Integer)InOutCurrentTest.WELL_COLS.getValue(); ++col) {
                this.store.setWellID(String.format("Well:%d_%d", row, col), 0, wellCount);
                this.store.setWellRow(new NonNegativeInteger(Integer.valueOf(row)), 0, wellCount);
                this.store.setWellColumn(new NonNegativeInteger(Integer.valueOf(col)), 0, wellCount);
                if (row == 0 && col == 0) {
                    this.store.setLongAnnotationID("Annotation:WellLong0", 0);
                    this.store.setLongAnnotationNamespace("test-ome-InOutCurrent-namespace", 0);
                    this.store.setLongAnnotationValue(InOutCurrentTest.WELL_ANNOTATION_VALUE, 0);
                    this.store.setWellAnnotationRef("Annotation:WellLong0", 0, wellCount, 0);
                }
                this.store.setWellSampleID(String.format("WellSample:%d_%d", row, col), 0, wellCount, 0);
                this.store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(wellSampleIndex)), 0, wellCount, 0);
                this.store.setWellSampleImageRef("Image:0", 0, wellCount, 0);
                ++wellSampleIndex;
                ++wellCount;
            }
        }
    }

    private void makeROI() {
        this.store.setROIID("ROI:5", 0);
        this.store.setCommentAnnotationID("Annotation:ROIString0", 9);
        this.store.setCommentAnnotationNamespace("test-ome-InOutCurrent-namespace", 9);
        this.store.setCommentAnnotationValue("Some extra ROI data", 9);
        this.store.setROIAnnotationRef("Annotation:ROIString0", 0, 0);
        this.store.setRectangleID("Shape:0", 0, 0);
        this.store.setRectangleX(InOutCurrentTest.RECTANGLE_X, 0, 0);
        this.store.setRectangleY(InOutCurrentTest.RECTANGLE_Y, 0, 0);
        this.store.setRectangleWidth(InOutCurrentTest.RECTANGLE_WIDTH, 0, 0);
        this.store.setRectangleHeight(InOutCurrentTest.RECTANGLE_HEIGHT, 0, 0);
    }
}

