/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DynamicMetadataOptionsTest {
    private static final String KEY = "test.key";
    private static final double DDELTA = 1.0E-7;
    private static final float FDELTA = 1.0E-7f;
    private DynamicMetadataOptions opt;

    private static void assertAlmostEquals(Double actual, Double expected) {
        Assert.assertEquals((double)actual, (double)expected, (double)1.0E-7);
    }

    private static void assertAlmostEquals(Float actual, Float expected) {
        Assert.assertEquals((float)actual.floatValue(), (float)expected.floatValue(), (float)1.0E-7f);
    }

    @DataProvider(name="booleanStrings")
    public Object[][] mkBools() {
        return new Object[][]{{"FALSE", "TRUE"}, {"False", "True"}, {"false", "true"}};
    }

    @DataProvider(name="integerCases")
    public Object[][] mkInts() {
        return new Object[][]{{"30", new Integer(30)}, {"-30", new Integer(-30)}};
    }

    @DataProvider(name="longCases")
    public Object[][] mkLongs() {
        return new Object[][]{{"30", new Long(30L)}, {"-30", new Long(-30L)}};
    }

    @DataProvider(name="floatCases")
    public Object[][] mkFloats() {
        return new Object[][]{{"3.14", new Float(3.14f)}, {"03.14", new Float(3.14f)}, {"-3.14", new Float(-3.14f)}};
    }

    @DataProvider(name="doubleCases")
    public Object[][] mkDoubles() {
        return new Object[][]{{"3.14", new Double(3.14)}, {"03.14", new Double(3.14)}, {"-3.14", new Double(-3.14)}};
    }

    @DataProvider(name="optionFiles")
    public Object[][] mkOptionFiles() {
        return new Object[][]{{"t1.tiff", null}, {"/t1.tiff", "/t1.tiff.bfoptions"}, {"/foo/t1.tiff", "/foo/t1.tiff.bfoptions"}};
    }

    @BeforeMethod
    public void setUp() {
        this.opt = new DynamicMetadataOptions();
    }

    @Test
    public void testString() {
        Assert.assertNull((Object)this.opt.get(KEY));
        Assert.assertNull((Object)this.opt.get(KEY), null);
        Assert.assertEquals((String)this.opt.get(KEY, "default"), (String)"default");
        this.opt.set(KEY, "v");
        Assert.assertEquals((String)this.opt.get(KEY), (String)"v");
        Assert.assertEquals((String)this.opt.get(KEY, null), (String)"v");
        Assert.assertEquals((String)this.opt.get(KEY, "default"), (String)"v");
        this.opt.set(KEY, null);
        Assert.assertNull((Object)this.opt.get(KEY));
        Assert.assertNull((Object)this.opt.get(KEY), null);
        Assert.assertEquals((String)this.opt.get(KEY, "default"), (String)"default");
    }

    @Test
    public void testEnum() {
        Assert.assertEquals((Object)this.opt.getEnum(KEY, (Enum)One.BAR), (Object)((Object)One.BAR));
        this.opt.setEnum(KEY, (Enum)One.FOO);
        Assert.assertEquals((Object)this.opt.getEnum(KEY, (Enum)One.BAR), (Object)((Object)One.FOO));
        Assert.assertEquals((Object)this.opt.getEnum(KEY, (Enum)Two.TAR), (Object)((Object)Two.FOO));
        this.opt.set(KEY, "TAR");
        Assert.assertEquals((Object)this.opt.getEnum(KEY, (Enum)Two.FOO), (Object)((Object)Two.TAR));
        this.opt.setEnum(KEY, null);
        Assert.assertEquals((Object)this.opt.getEnum(KEY, (Enum)Two.FOO), (Object)((Object)Two.FOO));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBadEnum() {
        this.opt.setEnum(KEY, (Enum)One.BAR);
        this.opt.getEnum(KEY, (Enum)Two.FOO);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEnumNullDefault() {
        this.opt.getEnum(KEY, null);
    }

    @Test
    public void testBoolean() {
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(false)));
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(true)));
        Assert.assertNull((Object)this.opt.getBoolean(KEY, null));
        Assert.assertNull((Object)this.opt.getBoolean(KEY));
        this.opt.setBoolean(KEY, Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(true)));
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY, null));
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY));
        this.opt.setBoolean(KEY, Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(false)));
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY, null));
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY));
        this.opt.setBoolean(KEY, null);
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(false)));
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY, Boolean.valueOf(true)));
        Assert.assertNull((Object)this.opt.getBoolean(KEY, null));
        Assert.assertNull((Object)this.opt.getBoolean(KEY));
    }

    @Test(dataProvider="booleanStrings")
    public void testBooleanFromString(String falseString, String trueString) {
        this.opt.set(KEY, falseString);
        Assert.assertFalse((boolean)this.opt.getBoolean(KEY));
        this.opt.set(KEY, trueString);
        Assert.assertTrue((boolean)this.opt.getBoolean(KEY));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBadBoolean() {
        this.opt.set(KEY, "foo");
        this.opt.getBoolean(KEY);
    }

    @Test
    public void testInteger() {
        Integer one = 1;
        Integer two = 2;
        Assert.assertEquals((Object)this.opt.getInteger(KEY, one), (Object)one);
        Assert.assertNull((Object)this.opt.getInteger(KEY, null));
        Assert.assertNull((Object)this.opt.getInteger(KEY));
        this.opt.setInteger(KEY, two);
        Assert.assertEquals((Object)this.opt.getInteger(KEY, one), (Object)two);
        Assert.assertEquals((Object)this.opt.getInteger(KEY, null), (Object)two);
        Assert.assertEquals((Object)this.opt.getInteger(KEY), (Object)two);
        this.opt.setInteger(KEY, null);
        Assert.assertEquals((Object)this.opt.getInteger(KEY, one), (Object)one);
        Assert.assertNull((Object)this.opt.getInteger(KEY, null));
        Assert.assertNull((Object)this.opt.getInteger(KEY));
    }

    @Test(dataProvider="integerCases")
    public void testIntFromString(String intString, Integer expected) {
        this.opt.set(KEY, intString);
        Assert.assertEquals((Object)this.opt.getInteger(KEY), (Object)expected);
    }

    @Test(expectedExceptions={NumberFormatException.class})
    public void testBadInt() {
        this.opt.set(KEY, "2147483648");
        this.opt.getInteger(KEY);
    }

    @Test
    public void testLong() {
        Long one = 1L;
        Long two = 2L;
        Assert.assertEquals((Object)this.opt.getLong(KEY, one), (Object)one);
        Assert.assertNull((Object)this.opt.getLong(KEY, null));
        Assert.assertNull((Object)this.opt.getLong(KEY));
        this.opt.setLong(KEY, two);
        Assert.assertEquals((Object)this.opt.getLong(KEY, one), (Object)two);
        Assert.assertEquals((Object)this.opt.getLong(KEY, null), (Object)two);
        Assert.assertEquals((Object)this.opt.getLong(KEY), (Object)two);
        this.opt.setLong(KEY, null);
        Assert.assertEquals((Object)this.opt.getLong(KEY, one), (Object)one);
        Assert.assertNull((Object)this.opt.getLong(KEY, null));
        Assert.assertNull((Object)this.opt.getLong(KEY));
    }

    @Test(dataProvider="longCases")
    public void testLongFromString(String longString, Long expected) {
        this.opt.set(KEY, longString);
        Assert.assertEquals((Object)this.opt.getLong(KEY), (Object)expected);
    }

    @Test(expectedExceptions={NumberFormatException.class})
    public void testBadLong() {
        this.opt.set(KEY, "9223372036854775808");
        this.opt.getLong(KEY);
    }

    @Test
    public void testFloat() {
        Float e = Float.valueOf(2.72f);
        Float pi = Float.valueOf(3.14f);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY, e), e);
        Assert.assertNull((Object)this.opt.getFloat(KEY, null));
        Assert.assertNull((Object)this.opt.getFloat(KEY));
        this.opt.setFloat(KEY, pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY, e), pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY, null), pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY), pi);
        this.opt.setFloat(KEY, null);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY, e), e);
        Assert.assertNull((Object)this.opt.getFloat(KEY, null));
        Assert.assertNull((Object)this.opt.getFloat(KEY));
    }

    @Test(dataProvider="floatCases")
    public void testFloatFromString(String floatString, Float expected) {
        this.opt.set(KEY, floatString);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getFloat(KEY), expected);
    }

    @Test(expectedExceptions={NumberFormatException.class})
    public void testBadFloat() {
        this.opt.set(KEY, "foo");
        this.opt.getFloat(KEY);
    }

    @Test
    public void testDouble() {
        Double e = 2.72;
        Double pi = 3.14;
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY, e), e);
        Assert.assertNull((Object)this.opt.getDouble(KEY, null));
        Assert.assertNull((Object)this.opt.getDouble(KEY));
        this.opt.setDouble(KEY, pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY, e), pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY, null), pi);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY), pi);
        this.opt.setDouble(KEY, null);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY, e), e);
        Assert.assertNull((Object)this.opt.getDouble(KEY, null));
        Assert.assertNull((Object)this.opt.getDouble(KEY));
    }

    @Test(dataProvider="doubleCases")
    public void testDoubleFromString(String doubleString, Double expected) {
        this.opt.set(KEY, doubleString);
        DynamicMetadataOptionsTest.assertAlmostEquals(this.opt.getDouble(KEY), expected);
    }

    @Test(expectedExceptions={NumberFormatException.class})
    public void testBadDouble() {
        this.opt.set(KEY, "foo");
        this.opt.getDouble(KEY);
    }

    @Test
    public void testClass() throws ClassNotFoundException {
        Class<Thread> c1 = Thread.class;
        Class<Number> c2 = Number.class;
        Assert.assertEquals((Object)this.opt.getClass(KEY, c1), c1);
        Assert.assertNull((Object)this.opt.getClass(KEY, null));
        Assert.assertNull((Object)this.opt.getClass(KEY));
        this.opt.setClass(KEY, c2);
        Assert.assertEquals((Object)this.opt.getClass(KEY, c1), c2);
        Assert.assertEquals((Object)this.opt.getClass(KEY, null), c2);
        Assert.assertEquals((Object)this.opt.getClass(KEY), c2);
        this.opt.set(KEY, "java.lang.Thread");
        Assert.assertEquals((Object)this.opt.getClass(KEY, c2), c1);
        this.opt.setClass(KEY, null);
        Assert.assertEquals((Object)this.opt.getClass(KEY, c2), c2);
        Assert.assertNull((Object)this.opt.getClass(KEY, null));
        Assert.assertNull((Object)this.opt.getClass(KEY));
    }

    @Test(expectedExceptions={ClassNotFoundException.class})
    public void testBadClass() throws ClassNotFoundException {
        this.opt.set(KEY, "org.foo.Bar");
        this.opt.getClass(KEY);
    }

    @Test
    public void testFile() {
        File f1 = new File("/foo/f1");
        File f2 = new File("/foo/f2");
        Assert.assertEquals((Object)this.opt.getFile(KEY, f1), (Object)f1);
        Assert.assertNull((Object)this.opt.getFile(KEY, null));
        Assert.assertNull((Object)this.opt.getFile(KEY));
        this.opt.setFile(KEY, f2);
        Assert.assertEquals((Object)this.opt.getFile(KEY, f1), (Object)f2);
        Assert.assertEquals((Object)this.opt.getFile(KEY, null), (Object)f2);
        Assert.assertEquals((Object)this.opt.getFile(KEY), (Object)f2);
        this.opt.set(KEY, "/foo/f1");
        Assert.assertEquals((Object)this.opt.getFile(KEY, f2), (Object)f1);
        this.opt.setFile(KEY, null);
        Assert.assertEquals((Object)this.opt.getFile(KEY, f2), (Object)f2);
        Assert.assertNull((Object)this.opt.getFile(KEY, null));
        Assert.assertNull((Object)this.opt.getFile(KEY));
    }

    @Test
    public void testMetadataLevel() {
        Assert.assertEquals((Object)this.opt.getMetadataLevel(), (Object)DynamicMetadataOptions.METADATA_LEVEL_DEFAULT);
        for (MetadataLevel level : MetadataLevel.values()) {
            this.opt.setMetadataLevel(level);
            Assert.assertEquals((Object)this.opt.getMetadataLevel(), (Object)level);
            Assert.assertEquals((Object)new DynamicMetadataOptions(level).getMetadataLevel(), (Object)level);
        }
    }

    @Test
    public void testIsValidate() {
        Assert.assertEquals((boolean)this.opt.isValidate(), (boolean)false);
        this.opt.setValidate(true);
        Assert.assertTrue((boolean)this.opt.isValidate());
        this.opt.setValidate(false);
        Assert.assertFalse((boolean)this.opt.isValidate());
    }

    @Test(dataProvider="optionFiles")
    public void testGetMetadataOptionsFile(String source, String target) {
        source = source.replace('/', File.separatorChar);
        if (target != null) {
            target = target.replace('/', File.separatorChar);
        }
        if ((source = DynamicMetadataOptions.getMetadataOptionsFile((String)source)) != null) {
            String[] values = source.split(":");
            source = values[values.length - 1];
        }
        Assert.assertEquals((String)source, (String)target);
    }

    private static enum One {
        FOO,
        BAR;

    }

    private static enum Two {
        TAR,
        FOO;

    }
}

