/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import jj2000.j2k.io.BufferedRandomAccessFile;
import jj2000.j2k.io.EndianType;
import jj2000.j2k.io.RandomAccessIO;

public class BEBufferedRandomAccessFile
extends BufferedRandomAccessFile
implements RandomAccessIO,
EndianType {
    public BEBufferedRandomAccessFile(File file2, String mode, int bufferSize) throws IOException {
        super(file2, mode, bufferSize);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(File file2, String mode) throws IOException {
        super(file2, mode);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(String name, String mode, int bufferSize) throws IOException {
        super(name, mode, bufferSize);
        this.byteOrdering = 0;
    }

    public BEBufferedRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
        this.byteOrdering = 0;
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8);
        this.write(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24);
        this.write(v >>> 16);
        this.write(v >>> 8);
        this.write(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56));
        this.write((int)(v >>> 48));
        this.write((int)(v >>> 40));
        this.write((int)(v >>> 32));
        this.write((int)(v >>> 24));
        this.write((int)(v >>> 16));
        this.write((int)(v >>> 8));
        this.write((int)v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        int intV = Float.floatToIntBits(v);
        this.write(intV >>> 24);
        this.write(intV >>> 16);
        this.write(intV >>> 8);
        this.write(intV);
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        long longV = Double.doubleToLongBits(v);
        this.write((int)(longV >>> 56));
        this.write((int)(longV >>> 48));
        this.write((int)(longV >>> 40));
        this.write((int)(longV >>> 32));
        this.write((int)(longV >>> 24));
        this.write((int)(longV >>> 16));
        this.write((int)(longV >>> 8));
        this.write((int)longV);
    }

    @Override
    public final short readShort() throws IOException, EOFException {
        return (short)(this.read() << 8 | this.read());
    }

    @Override
    public final int readUnsignedShort() throws IOException, EOFException {
        return this.read() << 8 | this.read();
    }

    @Override
    public final int readInt() throws IOException, EOFException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    @Override
    public final long readUnsignedInt() throws IOException, EOFException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    @Override
    public final long readLong() throws IOException, EOFException {
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    @Override
    public final float readFloat() throws EOFException, IOException {
        return Float.intBitsToFloat(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    @Override
    public final double readDouble() throws IOException, EOFException {
        return Double.longBitsToDouble((long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read());
    }

    @Override
    public String toString() {
        return super.toString() + "\nBig-Endian ordering";
    }
}

