/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.DummyStepHandler;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.StepHandler;
import org.apache.commons.math.ode.SwitchingFunction;
import org.apache.commons.math.ode.SwitchingFunctionsHandler;

public abstract class AdaptiveStepsizeIntegrator
implements FirstOrderIntegrator {
    private double minStep;
    private double maxStep;
    private double initialStep;
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected StepHandler handler;
    protected SwitchingFunctionsHandler switchesHandler;
    protected double stepStart;
    protected double stepSize;

    public AdaptiveStepsizeIntegrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = scalAbsoluteTolerance;
        this.scalRelativeTolerance = scalRelativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = vecAbsoluteTolerance;
        this.vecRelativeTolerance = vecRelativeTolerance;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStep = initialStepSize < this.minStep || initialStepSize > this.maxStep ? -1.0 : initialStepSize;
    }

    public void setStepHandler(StepHandler handler) {
        this.handler = handler;
    }

    public StepHandler getStepHandler() {
        return this.handler;
    }

    public void addSwitchingFunction(SwitchingFunction function, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.switchesHandler.add(function, maxCheckInterval, convergence, maxIterationCount);
    }

    protected void sanityChecks(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2, double[] y) throws IntegratorException {
        if (equations.getDimension() != y0.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, initial state vector has dimension {1}", new Object[]{new Integer(equations.getDimension()), new Integer(y0.length)});
        }
        if (equations.getDimension() != y.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, final state vector has dimension {1}", new Object[]{new Integer(equations.getDimension()), new Integer(y.length)});
        }
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != y0.length) {
            throw new IntegratorException("dimensions mismatch: state vector has dimension {0}, absolute tolerance vector has dimension {1}", new Object[]{new Integer(y0.length), new Integer(this.vecAbsoluteTolerance.length)});
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != y0.length) {
            throw new IntegratorException("dimensions mismatch: state vector has dimension {0}, relative tolerance vector has dimension {1}", new Object[]{new Integer(y0.length), new Integer(this.vecRelativeTolerance.length)});
        }
        if (Math.abs(t2 - t0) <= 1.0E-12 * Math.max(Math.abs(t0), Math.abs(t2))) {
            throw new IntegratorException("too small integration interval: length = {0}", new Object[]{new Double(Math.abs(t2 - t0))});
        }
    }

    public double initializeStep(FirstOrderDifferentialEquations equations, boolean forward, int order, double[] scale, double t0, double[] y0, double[] yDot0, double[] y1, double[] yDot1) throws DerivativeException {
        double h2;
        double ratio;
        if (this.initialStep > 0.0) {
            return forward ? this.initialStep : -this.initialStep;
        }
        double yOnScale2 = 0.0;
        double yDotOnScale2 = 0.0;
        for (int j = 0; j < y0.length; ++j) {
            ratio = y0[j] / scale[j];
            yOnScale2 += ratio * ratio;
            ratio = yDot0[j] / scale[j];
            yDotOnScale2 += ratio * ratio;
        }
        double d = h2 = yOnScale2 < 1.0E-10 || yDotOnScale2 < 1.0E-10 ? 1.0E-6 : 0.01 * Math.sqrt(yOnScale2 / yDotOnScale2);
        if (!forward) {
            h2 = -h2;
        }
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = y0[j] + h2 * yDot0[j];
        }
        equations.computeDerivatives(t0 + h2, y1, yDot1);
        double yDDotOnScale = 0.0;
        for (int j = 0; j < y0.length; ++j) {
            ratio = (yDot1[j] - yDot0[j]) / scale[j];
            yDDotOnScale += ratio * ratio;
        }
        yDDotOnScale = Math.sqrt(yDDotOnScale) / h2;
        double maxInv2 = Math.max(Math.sqrt(yDotOnScale2), yDDotOnScale);
        double h1 = maxInv2 < 1.0E-15 ? Math.max(1.0E-6, 0.001 * Math.abs(h2)) : Math.pow(0.01 / maxInv2, 1.0 / (double)order);
        h2 = Math.min(100.0 * Math.abs(h2), h1);
        if ((h2 = Math.max(h2, 1.0E-12 * Math.abs(t0))) < this.getMinStep()) {
            h2 = this.getMinStep();
        }
        if (h2 > this.getMaxStep()) {
            h2 = this.getMaxStep();
        }
        if (!forward) {
            h2 = -h2;
        }
        return h2;
    }

    protected double filterStep(double h2, boolean acceptSmall) throws IntegratorException {
        if (Math.abs(h2) < this.minStep) {
            if (acceptSmall) {
                h2 = h2 < 0.0 ? -this.minStep : this.minStep;
            } else {
                throw new IntegratorException("minimal step size ({0}) reached, integration needs {1}", new Object[]{new Double(this.minStep), new Double(Math.abs(h2))});
            }
        }
        if (h2 > this.maxStep) {
            h2 = this.maxStep;
        } else if (h2 < -this.maxStep) {
            h2 = -this.maxStep;
        }
        return h2;
    }

    public abstract void integrate(FirstOrderDifferentialEquations var1, double var2, double[] var4, double var5, double[] var7) throws DerivativeException, IntegratorException;

    public double getCurrentStepStart() {
        return this.stepStart;
    }

    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    protected void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = Math.sqrt(this.minStep * this.maxStep);
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

