/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.Macro;
import java.io.IOException;
import loci.plugins.in.ImporterOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MacroTest {
    private static final String OLD_MERGE = "merge_channels view=Hyperstack stack_order=XYCZT ";
    private static final String NEW_MERGE = "color_mode=Composite view=Hyperstack stack_order=XYCZT ";
    private static final String OLD_AUTO_COLORIZE = "rgb_colorize view=Hyperstack stack_order=XYCZT ";
    private static final String NEW_AUTO_COLORIZE = "color_mode=Colorized view=Hyperstack stack_order=XYCZT ";
    private static final String OLD_CUSTOM_COLORIZE = "custom_colorize view=Hyperstack stack_order=XYCZT series_0_channel_0_red=231 series_0_channel_0_green=100 series_0_channel_0_blue=136 series_0_channel_1_red=143 series_0_channel_1_green=214 series_0_channel_1_blue=100 series_0_channel_2_red=240 series_0_channel_2_green=200 series_0_channel_2_blue=120 ";
    private static final String NEW_CUSTOM_COLORIZE = "color_mode=Custom view=Hyperstack stack_order=XYCZT series_0_channel_0_red=231 series_0_channel_0_green=100 series_0_channel_0_blue=136 series_0_channel_1_red=143 series_0_channel_1_green=214 series_0_channel_1_blue=100 series_0_channel_2_red=240 series_0_channel_2_green=200 series_0_channel_2_blue=120 ";
    private static final String COMPOSITE_MODE = "color_mode=Composite ";
    private static final String COLORIZED_MODE = "color_mode=Colorized ";

    @Test
    public void testMergeChannels() {
        ImporterOptions oldOptions = this.getOptions(OLD_MERGE);
        ImporterOptions newOptions = this.getOptions(NEW_MERGE);
        Assert.assertEquals((Object)oldOptions, (Object)newOptions);
    }

    @Test
    public void testAutoColorizeChannels() {
        ImporterOptions oldOptions = this.getOptions(OLD_AUTO_COLORIZE);
        ImporterOptions newOptions = this.getOptions(NEW_AUTO_COLORIZE);
        Assert.assertEquals((Object)oldOptions, (Object)newOptions);
    }

    @Test
    public void testCustomColorizeChannels() {
        ImporterOptions oldOptions = this.getOptions(OLD_CUSTOM_COLORIZE);
        ImporterOptions newOptions = this.getOptions(NEW_CUSTOM_COLORIZE);
        Assert.assertEquals((Object)oldOptions, (Object)newOptions);
    }

    @Test
    public void testDisjointColorModes() {
        ImporterOptions composite = this.getOptions(COMPOSITE_MODE);
        ImporterOptions colorized = this.getOptions(COLORIZED_MODE);
        Assert.assertFalse((boolean)composite.equals((Object)colorized));
        Assert.assertEquals((String)composite.getColorMode(), (String)"Composite");
        Assert.assertEquals((String)colorized.getColorMode(), (String)"Colorized");
    }

    @Test
    public void testEqualMacros() {
        ImporterOptions compositeA = this.getOptions(COMPOSITE_MODE);
        ImporterOptions compositeB = this.getOptions(COMPOSITE_MODE);
        Assert.assertEquals((Object)compositeA, (Object)compositeB);
        Assert.assertEquals((String)compositeA.getColorMode(), (String)"Composite");
        Assert.assertEquals((String)compositeB.getColorMode(), (String)"Composite");
    }

    private ImporterOptions getOptions(String macro) {
        Thread current = Thread.currentThread();
        current.setName("Run$_" + current.getName());
        try {
            Macro.setOptions((String)macro);
            ImporterOptions options = new ImporterOptions();
            options.parseArg(macro);
            options.checkObsoleteOptions();
            return options;
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

