/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.InputStream;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.Image;
import ome.xml.model.Label;
import ome.xml.model.OME;
import ome.xml.model.ROI;
import ome.xml.model.Shape;
import ome.xml.model.Union;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Upgrade201106Test {
    private static final String XML_FILE = "2011-06.ome";
    private OMEXMLService service;
    private String xml;
    private OMEXMLMetadata metadata;
    private OME ome;

    @BeforeMethod
    public void setUp() throws Exception {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        InputStream s = Upgrade201106Test.class.getResourceAsStream(XML_FILE);
        byte[] b = new byte[s.available()];
        s.read(b);
        s.close();
        this.xml = new String(b);
        this.metadata = this.service.createOMEXMLMetadata(this.xml);
        this.ome = (OME)this.metadata.getRoot();
    }

    @Test
    public void getOMEXMLVersion() throws ServiceException {
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)this.metadata));
    }

    @Test
    public void validateUpgrade() throws ServiceException {
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        AssertJUnit.assertNotNull((Object)image.getAcquisitionDate());
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfROIList());
        ROI roi = this.ome.getROI(0);
        Union union = roi.getUnion();
        AssertJUnit.assertEquals((int)1, (int)union.sizeOfShapeList());
        Shape shape = union.getShape(0);
        AssertJUnit.assertTrue((boolean)(shape instanceof Label));
        AssertJUnit.assertNotNull((Object)shape.getText());
    }
}

