/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.tests.testng.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationTree.class);
    private String rootDir;
    private String configDir;
    private String cacheDir;
    private DefaultMutableTreeNode root;

    public ConfigurationTree(String rootDir) {
        this(rootDir, null);
    }

    public ConfigurationTree(String rootDir, String configDir) {
        this(rootDir, configDir, null);
    }

    public ConfigurationTree(String rootDir, String configDir, String cacheDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException("rootDir cannot be null.");
        }
        this.rootDir = new File(rootDir).getAbsolutePath();
        if (configDir != null) {
            this.configDir = new File(configDir).getAbsolutePath();
        }
        if (cacheDir != null) {
            this.cacheDir = new File(cacheDir).getAbsolutePath();
        }
        this.root = new DefaultMutableTreeNode();
    }

    public String getRootDirectory() {
        return this.rootDir;
    }

    public String getConfigDirectory() {
        return this.configDir;
    }

    public String getCacheDirectory() {
        return this.cacheDir;
    }

    public String relocate(String path, String oldRoot, String newRoot) {
        if (!path.startsWith(oldRoot)) {
            return path;
        }
        String subPath = path.substring(Math.min(oldRoot.length() + 1, path.length()));
        if (subPath.length() == 0) {
            return newRoot;
        }
        return new Location(newRoot, subPath).getAbsolutePath();
    }

    public String relocateToConfig(String path) {
        return this.relocate(path, this.rootDir, this.configDir);
    }

    public String relocateToRoot(String path) {
        return this.relocate(path, this.configDir, this.rootDir);
    }

    public Configuration get(String id) throws IOException {
        DefaultMutableTreeNode pos = this.findNode(id, false, null);
        if (pos == null) {
            return null;
        }
        Hashtable table = (Hashtable)pos.getUserObject();
        return (Configuration)table.get("configuration");
    }

    public void parseConfigFile(String configFile) throws IOException {
        File file = new File(configFile);
        if (file.isDirectory()) {
            return;
        }
        String parent = file.getParent();
        if (this.configDir != null) {
            parent = this.relocateToRoot(parent);
        }
        configFile = file.getAbsolutePath();
        String dir = file.getParentFile().getAbsolutePath();
        IniParser parser = new IniParser();
        parser.setCommentDelimiter(null);
        FileInputStream stream = new FileInputStream(configFile);
        IniList iniList = parser.parseINI(new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8")));
        for (IniTable table : iniList) {
            String id = (String)table.get((Object)"header");
            id = id.substring(0, id.lastIndexOf(" "));
            DefaultMutableTreeNode node = this.findNode(id = new File(parent, id).getAbsolutePath(), true, configFile);
            if (node != null) continue;
            LOGGER.warn("config file '{}' has invalid filename '{}'", (Object)configFile, (Object)id);
        }
    }

    private DefaultMutableTreeNode findNode(String id, boolean create, String configFile) {
        String baseID = id;
        if (!id.startsWith(this.rootDir)) {
            return null;
        }
        id = id.substring(this.rootDir.length());
        StringTokenizer st = new StringTokenizer(id, "\\/");
        DefaultMutableTreeNode node = this.root;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Enumeration<TreeNode> en = node.children();
            DefaultMutableTreeNode next = null;
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                Hashtable table = (Hashtable)child.getUserObject();
                if (!token.equals(table.get("name"))) continue;
                next = child;
                break;
            }
            if (next == null) {
                if (!create) {
                    return null;
                }
                next = new DefaultMutableTreeNode();
                Hashtable<String, Object> table = new Hashtable<String, Object>();
                table.put("name", token);
                try {
                    table.put("configuration", new Configuration(baseID, configFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                next.setUserObject(table);
                node.add(next);
            }
            node = next;
        }
        return node;
    }
}

