/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadByteBufferTest {
    private static final byte[] PAGE = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, -1, -2};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 2;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 2);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadByte() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(16);
        int length = this.fileHandle.read(b);
        b.position(0);
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((int)16, (int)length);
        AssertJUnit.assertEquals((int)1, (int)b.get());
        AssertJUnit.assertEquals((int)2, (int)b.get());
        AssertJUnit.assertEquals((int)3, (int)b.get());
        AssertJUnit.assertEquals((int)4, (int)b.get());
        AssertJUnit.assertEquals((int)5, (int)b.get());
        AssertJUnit.assertEquals((int)6, (int)b.get());
        AssertJUnit.assertEquals((int)7, (int)b.get());
        AssertJUnit.assertEquals((int)8, (int)b.get());
        AssertJUnit.assertEquals((int)9, (int)b.get());
        AssertJUnit.assertEquals((int)10, (int)b.get());
        AssertJUnit.assertEquals((int)11, (int)b.get());
        AssertJUnit.assertEquals((int)12, (int)b.get());
        AssertJUnit.assertEquals((int)13, (int)b.get());
        AssertJUnit.assertEquals((int)14, (int)b.get());
        AssertJUnit.assertEquals((byte)-1, (byte)b.get());
        AssertJUnit.assertEquals((byte)-2, (byte)b.get());
    }

    @Test
    public void testSeekForwardReadByte() throws IOException {
        this.fileHandle.seek(7L);
        ByteBuffer b = ByteBuffer.allocate(2);
        int length = this.fileHandle.read(b);
        b.position(0);
        AssertJUnit.assertEquals((long)9L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((int)2, (int)length);
        AssertJUnit.assertEquals((int)8, (int)b.get());
        AssertJUnit.assertEquals((int)9, (int)b.get());
    }

    @Test
    public void testResetReadByte() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(2);
        int length = this.fileHandle.read(b);
        b.position(0);
        AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((int)2, (int)length);
        AssertJUnit.assertEquals((int)1, (int)b.get());
        AssertJUnit.assertEquals((int)2, (int)b.get());
        this.fileHandle.seek(0L);
        b.position(0);
        length = this.fileHandle.read(b);
        b.position(0);
        AssertJUnit.assertEquals((int)2, (int)length);
        AssertJUnit.assertEquals((int)1, (int)b.get());
        AssertJUnit.assertEquals((int)2, (int)b.get());
    }

    @Test
    public void testSeekBackReadByte() throws IOException {
        this.fileHandle.seek(15L);
        this.fileHandle.seek(7L);
        ByteBuffer b = ByteBuffer.allocate(2);
        int length = this.fileHandle.read(b);
        b.position(0);
        AssertJUnit.assertEquals((long)9L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((int)2, (int)length);
        AssertJUnit.assertEquals((int)8, (int)b.get());
        AssertJUnit.assertEquals((int)9, (int)b.get());
    }

    @Test
    public void testRandomAccessReadByte() throws IOException {
        this.testSeekForwardReadByte();
        this.testSeekBackReadByte();
        this.fileHandle.seek(0L);
        this.testResetReadByte();
    }
}

