/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadDoubleTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, -65, -16, 0, 0, 0, 0, 0, 0, 64, 9, 33, -5, 84, 68, 45, 24, 127, -17, -1, -1, -1, -1, -1, -1, -1, -16, 0, 0, 0, 0, 0, 0, 127, -8, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)56L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        AssertJUnit.assertEquals((Object)0.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)-1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Math.PI, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.MAX_VALUE, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Double.NaN, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((Object)-1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Math.PI, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testReset() throws IOException {
        AssertJUnit.assertEquals((Object)0.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)1.0, (Object)this.fileHandle.readDouble());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)0.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)1.0, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testSeekBack() throws IOException {
        this.fileHandle.seek(32L);
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((Object)-1.0, (Object)this.fileHandle.readDouble());
        AssertJUnit.assertEquals((Object)Math.PI, (Object)this.fileHandle.readDouble());
    }

    @Test
    public void testRandomAccess() throws IOException {
        this.testSeekForward();
        this.testSeekBack();
        this.fileHandle.seek(0L);
        this.testReset();
    }
}

