/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteShortTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.writeShort(1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3842);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)6L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3844);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(5);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)10L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3846);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(7);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)14L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3848);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(9);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3850);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)20L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(11);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)22L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3852);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(13);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)26L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(-1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)28L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(15);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)30L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(-2);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3842, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3844, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3848, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3850, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)11, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3852, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)13, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)-1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)15, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)-2, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        this.fileHandle.writeShort(5);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)10L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3846);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.writeShort(1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeShort(3842);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3842, (int)this.fileHandle.readShort());
        this.fileHandle.seek(0L);
        this.fileHandle.writeShort(5);
        this.fileHandle.writeShort(3846);
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
    }
}

