/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UncompressInputStream
extends FilterInputStream {
    private static final int TBL_CLEAR = 256;
    private static final int TBL_FIRST = 257;
    private int[] tab_prefix;
    private byte[] tab_suffix;
    private int[] zeros = new int[256];
    private byte[] stack;
    private boolean block_mode;
    private int n_bits;
    private int maxbits;
    private int maxmaxcode;
    private int maxcode;
    private int bitmask;
    private int oldcode;
    private byte finchar;
    private int stackp;
    private int free_ent;
    private byte[] data = new byte[10000];
    private int bit_pos;
    private int end;
    private int got;
    private boolean eof;
    private static final int EXTRA = 64;
    private byte[] one = new byte[1];
    private static final int LZW_MAGIC = 8093;
    private static final int MAX_BITS = 16;
    private static final int INIT_BITS = 9;
    private static final int HDR_MAXBITS = 31;
    private static final int HDR_EXTENDED = 32;
    private static final int HDR_FREE = 64;
    private static final int HDR_BLOCK_MODE = 128;
    private static final boolean debug = false;
    private static final boolean debugTiming = false;

    public UncompressInputStream(InputStream is) throws IOException {
        super(is);
        this.parse_header();
    }

    @Override
    public int read() throws IOException {
        int b = this.read(this.one, 0, 1);
        if (b == 1) {
            return this.one[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int start = off;
        int[] l_tab_prefix = this.tab_prefix;
        byte[] l_tab_suffix = this.tab_suffix;
        byte[] l_stack = this.stack;
        int l_n_bits = this.n_bits;
        int l_maxcode = this.maxcode;
        int l_maxmaxcode = this.maxmaxcode;
        int l_bitmask = this.bitmask;
        int l_oldcode = this.oldcode;
        byte l_finchar = this.finchar;
        int l_stackp = this.stackp;
        int l_free_ent = this.free_ent;
        byte[] l_data = this.data;
        int l_bit_pos = this.bit_pos;
        int s_size = l_stack.length - l_stackp;
        if (s_size > 0) {
            int num = s_size >= len ? len : s_size;
            System.arraycopy(l_stack, l_stackp, buf, off, num);
            off += num;
            len -= num;
            l_stackp += num;
        }
        if (len == 0) {
            this.stackp = l_stackp;
            return off - start;
        }
        block0: do {
            int bit_in;
            if (this.end < 64) {
                this.fill();
            }
            int n = bit_in = this.got > 0 ? this.end - this.end % l_n_bits << 3 : (this.end << 3) - (l_n_bits - 1);
            while (l_bit_pos < bit_in) {
                if (len == 0) {
                    this.n_bits = l_n_bits;
                    this.maxcode = l_maxcode;
                    this.maxmaxcode = l_maxmaxcode;
                    this.bitmask = l_bitmask;
                    this.oldcode = l_oldcode;
                    this.finchar = l_finchar;
                    this.stackp = l_stackp;
                    this.free_ent = l_free_ent;
                    this.bit_pos = l_bit_pos;
                    return off - start;
                }
                if (l_free_ent > l_maxcode) {
                    int n_bytes = l_n_bits << 3;
                    l_bit_pos = l_bit_pos - 1 + n_bytes - (l_bit_pos - 1 + n_bytes) % n_bytes;
                    l_maxcode = ++l_n_bits == this.maxbits ? l_maxmaxcode : (1 << l_n_bits) - 1;
                    l_bitmask = (1 << l_n_bits) - 1;
                    l_bit_pos = this.resetbuf(l_bit_pos);
                    continue block0;
                }
                int pos = l_bit_pos >> 3;
                int code = (l_data[pos] & 0xFF | (l_data[pos + 1] & 0xFF) << 8 | (l_data[pos + 2] & 0xFF) << 16) >> (l_bit_pos & 7) & l_bitmask;
                l_bit_pos += l_n_bits;
                if (l_oldcode == -1) {
                    if (code >= 256) {
                        throw new IOException("corrupt input: " + code + " > 255");
                    }
                    l_oldcode = code;
                    l_finchar = (byte)l_oldcode;
                    buf[off++] = l_finchar;
                    --len;
                    continue;
                }
                if (code == 256 && this.block_mode) {
                    System.arraycopy(this.zeros, 0, l_tab_prefix, 0, this.zeros.length);
                    l_free_ent = 256;
                    int n_bytes = l_n_bits << 3;
                    l_bit_pos = l_bit_pos - 1 + n_bytes - (l_bit_pos - 1 + n_bytes) % n_bytes;
                    l_n_bits = 9;
                    l_bitmask = l_maxcode = (1 << l_n_bits) - 1;
                    l_bit_pos = this.resetbuf(l_bit_pos);
                    continue block0;
                }
                int incode = code;
                l_stackp = l_stack.length;
                if (code >= l_free_ent) {
                    if (code > l_free_ent) {
                        throw new IOException("corrupt input: code=" + code + ", free_ent=" + l_free_ent);
                    }
                    l_stack[--l_stackp] = l_finchar;
                    code = l_oldcode;
                }
                while (code >= 256) {
                    l_stack[--l_stackp] = l_tab_suffix[code];
                    code = l_tab_prefix[code];
                }
                l_finchar = l_tab_suffix[code];
                buf[off++] = l_finchar;
                s_size = l_stack.length - l_stackp;
                int num = s_size >= --len ? len : s_size;
                System.arraycopy(l_stack, l_stackp, buf, off, num);
                off += num;
                len -= num;
                l_stackp += num;
                if (l_free_ent < l_maxmaxcode) {
                    l_tab_prefix[l_free_ent] = l_oldcode;
                    l_tab_suffix[l_free_ent] = l_finchar;
                    ++l_free_ent;
                }
                l_oldcode = incode;
                if (len != 0) continue;
                this.n_bits = l_n_bits;
                this.maxcode = l_maxcode;
                this.bitmask = l_bitmask;
                this.oldcode = l_oldcode;
                this.finchar = l_finchar;
                this.stackp = l_stackp;
                this.free_ent = l_free_ent;
                this.bit_pos = l_bit_pos;
                return off - start;
            }
            l_bit_pos = this.resetbuf(l_bit_pos);
        } while (this.got > 0);
        this.n_bits = l_n_bits;
        this.maxcode = l_maxcode;
        this.bitmask = l_bitmask;
        this.oldcode = l_oldcode;
        this.finchar = l_finchar;
        this.stackp = l_stackp;
        this.free_ent = l_free_ent;
        this.bit_pos = l_bit_pos;
        this.eof = true;
        return off - start;
    }

    private int resetbuf(int bit_pos) {
        int pos = bit_pos >> 3;
        System.arraycopy(this.data, pos, this.data, 0, this.end - pos);
        this.end -= pos;
        return 0;
    }

    private void fill() throws IOException {
        this.got = this.in.read(this.data, this.end, this.data.length - 1 - this.end);
        if (this.got > 0) {
            this.end += this.got;
        }
    }

    @Override
    public long skip(long num) throws IOException {
        byte[] tmp = new byte[(int)num];
        int got = this.read(tmp, 0, (int)num);
        if (got > 0) {
            return got;
        }
        return 0L;
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int avail = this.in.available();
        return avail == 0 ? 1 : avail;
    }

    private void parse_header() throws IOException {
        int t2 = this.in.read();
        if (t2 < 0) {
            throw new EOFException("Failed to read magic number");
        }
        int magic = (t2 & 0xFF) << 8;
        t2 = this.in.read();
        if (t2 < 0) {
            throw new EOFException("Failed to read magic number");
        }
        if ((magic += t2 & 0xFF) != 8093) {
            throw new IOException("Input not in compress format (read magic number 0x" + Integer.toHexString(magic) + ")");
        }
        int header = this.in.read();
        if (header < 0) {
            throw new EOFException("Failed to read header");
        }
        this.block_mode = (header & 0x80) > 0;
        this.maxbits = header & 0x1F;
        if (this.maxbits > 16) {
            throw new IOException("Stream compressed with " + this.maxbits + " bits, but can only handle " + 16 + " bits");
        }
        if ((header & 0x20) > 0) {
            throw new IOException("Header extension bit set");
        }
        if ((header & 0x40) > 0) {
            throw new IOException("Header bit 6 set");
        }
        this.maxmaxcode = 1 << this.maxbits;
        this.n_bits = 9;
        this.bitmask = this.maxcode = (1 << this.n_bits) - 1;
        this.oldcode = -1;
        this.finchar = 0;
        this.free_ent = this.block_mode ? 257 : 256;
        this.tab_prefix = new int[1 << this.maxbits];
        this.tab_suffix = new byte[1 << this.maxbits];
        this.stack = new byte[1 << this.maxbits];
        this.stackp = this.stack.length;
        for (int idx = 255; idx >= 0; --idx) {
            this.tab_suffix[idx] = (byte)idx;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public static void uncompress(String fileInName, FileOutputStream out) throws IOException {
        long start = System.currentTimeMillis();
        int total = 0;
        try (UncompressInputStream in = new UncompressInputStream(new FileInputStream(fileInName));){
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                total += bytesRead;
            }
        }
    }
}

